/*!

JSZip v3.1.5 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/master/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/master/LICENSE
*/
'use strict';(function(R){"object"===typeof exports&&"undefined"!==typeof module?module.exports=R():"function"===typeof define&&define.amd?define([],R):("undefined"!==typeof window?window:"undefined"!==typeof global?global:"undefined"!==typeof self?self:this).JSZip=R()})(function(){return function b(g,c,d){function e(h,f){if(!c[h]){if(!g[h]){var q="function"==typeof require&&require;if(!f&&q)return q(h,!0);if(a)return a(h,!0);q=Error("Cannot find module '"+h+"'");throw q.code="MODULE_NOT_FOUND",q;
}q=c[h]={exports:{}};g[h][0].call(q.exports,function(a){var d=g[h][1][a];return e(d?d:a)},q,q.exports,b,g,c,d)}return c[h].exports}for(var a="function"==typeof require&&require,h=0;h<d.length;h++)e(d[h]);return e}({1:[function(b,g,c){var d=b("./utils"),e=b("./support");c.encode=function(a){for(var b=[],e,f,q,c,p=0,y=a.length,G=y,F="string"!==d.getTypeOf(a);p<a.length;)G=y-p,F?(e=a[p++],f=p<y?a[p++]:0,q=p<y?a[p++]:0):(e=a.charCodeAt(p++),f=p<y?a.charCodeAt(p++):0,q=p<y?a.charCodeAt(p++):0),c=e>>2,
e=(e&3)<<4|f>>4,f=1<G?(f&15)<<2|q>>6:64,q=2<G?q&63:64,b.push("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(c)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(e)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(f)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(q));return b.join("")};c.decode=function(a){var d,b,f,q,c,p=0,y=0;if("data:"===a.substr(0,5))throw Error("Invalid base64 input, it looks like a data url.");
a=a.replace(/[^A-Za-z0-9\+\/\=]/g,"");q=3*a.length/4;"="===a.charAt(a.length-1)&&q--;"="===a.charAt(a.length-2)&&q--;if(0!==q%1)throw Error("Invalid base64 input, bad content length.");var G;for(G=e.uint8array?new Uint8Array(q|0):Array(q|0);p<a.length;)d="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(p++)),b="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(p++)),q="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(p++)),
c="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(p++)),d=d<<2|b>>4,b=(b&15)<<4|q>>2,f=(q&3)<<6|c,G[y++]=d,64!==q&&(G[y++]=b),64!==c&&(G[y++]=f);return G}},{"./support":30,"./utils":32}],2:[function(b,g,c){function d(a,d,b,p,y){this.compressedSize=a;this.uncompressedSize=d;this.crc32=b;this.compression=p;this.compressedContent=y}var e=b("./external"),a=b("./stream/DataWorker"),h=b("./stream/DataLengthProbe"),k=b("./stream/Crc32Probe"),h=b("./stream/DataLengthProbe");
d.prototype={getContentWorker:function(){var d=(new a(e.Promise.resolve(this.compressedContent))).pipe(this.compression.uncompressWorker()).pipe(new h("data_length")),b=this;d.on("end",function(){if(this.streamInfo.data_length!==b.uncompressedSize)throw Error("Bug : uncompressed data size mismatch");});return d},getCompressedWorker:function(){return(new a(e.Promise.resolve(this.compressedContent))).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",
this.crc32).withStreamInfo("compression",this.compression)}};d.createWorkerFrom=function(a,d,b){return a.pipe(new k).pipe(new h("uncompressedSize")).pipe(d.compressWorker(b)).pipe(new h("compressedSize")).withStreamInfo("compression",d)};g.exports=d},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(b,g,c){var d=b("./stream/GenericWorker");c.STORE={magic:"\x00\x00",compressWorker:function(b){return new d("STORE compression")},uncompressWorker:function(){return new d("STORE decompression")}};
c.DEFLATE=b("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(b,g,c){var d=b("./utils"),e=function(){for(var a,d=[],b=0;256>b;b++){a=b;for(var e=0;8>e;e++)a=a&1?3988292384^a>>>1:a>>>1;d[b]=a}return d}();g.exports=function(a,b){if("undefined"===typeof a||!a.length)return 0;if("string"!==d.getTypeOf(a)){var k,f=0+a.length;k=(b|0)^-1;for(var q=0;q<f;q++)k=k>>>8^e[(k^a[q])&255];return k^-1}f=0+a.length;k=(b|0)^-1;for(q=0;q<f;q++)k=k>>>8^e[(k^a.charCodeAt(q))&255];return k^-1}},{"./utils":32}],
5:[function(b,g,c){c.base64=!1;c.binary=!1;c.dir=!1;c.createFolders=!0;c.date=null;c.compression=null;c.compressionOptions=null;c.comment=null;c.unixPermissions=null;c.dosPermissions=null},{}],6:[function(b,g,c){c=null;c="undefined"!==typeof Promise?Promise:b("lie");g.exports={Promise:c}},{lie:58}],7:[function(b,g,c){function d(a,d){h.call(this,"FlateWorker/"+a);this._pako=null;this._pakoAction=a;this._pakoOptions=d;this.meta={}}g="undefined"!==typeof Uint8Array&&"undefined"!==typeof Uint16Array&&
"undefined"!==typeof Uint32Array;var e=b("pako"),a=b("./utils"),h=b("./stream/GenericWorker"),k=g?"uint8array":"array";c.magic="\b\x00";a.inherits(d,h);d.prototype.processChunk=function(d){this.meta=d.meta;null===this._pako&&this._createPako();this._pako.push(a.transformTo(k,d.data),!1)};d.prototype.flush=function(){h.prototype.flush.call(this);null===this._pako&&this._createPako();this._pako.push([],!0)};d.prototype.cleanUp=function(){h.prototype.cleanUp.call(this);this._pako=null};d.prototype._createPako=
function(){this._pako=new e[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var a=this;this._pako.onData=function(d){a.push({data:d,meta:a.meta})}};c.compressWorker=function(a){return new d("Deflate",a)};c.uncompressWorker=function(){return new d("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:59}],8:[function(b,g,c){function d(d,b,p,e){a.call(this,"ZipFileWorker");this.bytesWritten=0;this.zipComment=b;this.zipPlatform=p;this.encodeFileName=e;this.streamFiles=d;this.accumulate=
!1;this.contentBuffer=[];this.dirRecords=[];this.entriesCount=this.currentSourceOffset=0;this.currentFile=null;this._sources=[]}var e=b("../utils"),a=b("../stream/GenericWorker"),h=b("../utf8"),k=b("../crc32"),f=b("../signature"),q=function(a,d){var b="",p;for(p=0;p<d;p++)b+=String.fromCharCode(a&255),a>>>=8;return b},A=function(a,d,b,p,w,x){var r=a.file,c=a.compression,t=x!==h.utf8encode,A=e.transformTo("string",x(r.name)),B=e.transformTo("string",h.utf8encode(r.name)),v=r.comment;x=e.transformTo("string",
x(v));var g=e.transformTo("string",h.utf8encode(v)),H=B.length!==r.name.length,D=g.length!==v.length,m=v="",m="",n=r.dir,m=r.date,l=0,J=0,u=0;if(!d||b)l=a.crc32,J=a.compressedSize,u=a.uncompressedSize;a=0;d&&(a|=8);t||!H&&!D||(a|=2048);t=d=0;n&&(d|=16);"UNIX"===w?(t=798,(r=w=r.unixPermissions)||(r=n?16893:33204),d|=(r&65535)<<16):(t=20,d|=(r.dosPermissions||0)&63);w=m.getUTCHours();w=w<<6|m.getUTCMinutes();w<<=5;w|=m.getUTCSeconds()/2;r=m.getUTCFullYear()-1980;r=r<<4|m.getUTCMonth()+1;r<<=5;r|=m.getUTCDate();
H&&(m=q(1,1)+q(k(A),4)+B,v+="up"+q(m.length,2)+m);D&&(m=q(1,1)+q(k(x),4)+g,v+="uc"+q(m.length,2)+m);B="\n\x00"+q(a,2);B+=c.magic;B+=q(w,2);B+=q(r,2);B+=q(l,4);B+=q(J,4);B+=q(u,4);B+=q(A.length,2);B+=q(v.length,2);c=f.LOCAL_FILE_HEADER+B+A+v;p=f.CENTRAL_FILE_HEADER+q(t,2)+B+q(x.length,2)+"\x00\x00\x00\x00"+q(d,4)+q(p,4)+A+v+x;return{fileRecord:c,dirRecord:p}},p=function(a){var d="";return d=f.DATA_DESCRIPTOR+q(a.crc32,4)+q(a.compressedSize,4)+q(a.uncompressedSize,4)};e.inherits(d,a);d.prototype.push=
function(d){var b=d.meta.percent||0,p=this.entriesCount,e=this._sources.length;this.accumulate?this.contentBuffer.push(d):(this.bytesWritten+=d.data.length,a.prototype.push.call(this,{data:d.data,meta:{currentFile:this.currentFile,percent:p?(b+100*(p-e-1))/p:100}}))};d.prototype.openedSource=function(a){this.currentSourceOffset=this.bytesWritten;this.currentFile=a.file.name;var d=this.streamFiles&&!a.file.dir;d?(a=A(a,d,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName),this.push({data:a.fileRecord,
meta:{percent:0}})):this.accumulate=!0};d.prototype.closedSource=function(a){this.accumulate=!1;var d=this.streamFiles&&!a.file.dir,b=A(a,d,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.dirRecords.push(b.dirRecord);if(d)this.push({data:p(a),meta:{percent:100}});else for(this.push({data:b.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null};d.prototype.flush=function(){for(var a=this.bytesWritten,d=0;d<this.dirRecords.length;d++)this.push({data:this.dirRecords[d],
meta:{percent:100}});var d=this.dirRecords.length,b=this.bytesWritten-a,p="",p=e.transformTo("string",(0,this.encodeFileName)(this.zipComment)),p=f.CENTRAL_DIRECTORY_END+"\x00\x00\x00\x00"+q(d,2)+q(d,2)+q(b,4)+q(a,4)+q(p.length,2)+p;this.push({data:p,meta:{percent:100}})};d.prototype.prepareNextSource=function(){this.previous=this._sources.shift();this.openedSource(this.previous.streamInfo);this.isPaused?this.previous.pause():this.previous.resume()};d.prototype.registerPrevious=function(a){this._sources.push(a);
var d=this;a.on("data",function(a){d.processChunk(a)});a.on("end",function(){d.closedSource(d.previous.streamInfo);d._sources.length?d.prepareNextSource():d.end()});a.on("error",function(a){d.error(a)});return this};d.prototype.resume=function(){if(!a.prototype.resume.call(this))return!1;if(!this.previous&&this._sources.length)return this.prepareNextSource(),!0;if(!this.previous&&!this._sources.length&&!this.generatedError)return this.end(),!0};d.prototype.error=function(d){var b=this._sources;if(!a.prototype.error.call(this,
d))return!1;for(var p=0;p<b.length;p++)try{b[p].error(d)}catch(e){}return!0};d.prototype.lock=function(){a.prototype.lock.call(this);for(var d=this._sources,b=0;b<d.length;b++)d[b].lock()};g.exports=d},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(b,g,c){var d=b("../compressions"),e=b("./ZipFileWorker");c.generateWorker=function(a,b,k){var f=new e(b.streamFiles,k,b.platform,b.encodeFileName),q=0;try{a.forEach(function(a,p){q++;var e=p.options.compression||
b.compression,k=d[e];if(!k)throw Error(e+" is not a valid compression method !");var e=p.dir,c=p.date;p._compressWorker(k,p.options.compressionOptions||b.compressionOptions||{}).withStreamInfo("file",{name:a,dir:e,date:c,comment:p.comment||"",unixPermissions:p.unixPermissions,dosPermissions:p.dosPermissions}).pipe(f)}),f.entriesCount=q}catch(c){f.error(c)}return f}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(b,g,c){function d(){if(!(this instanceof d))return new d;if(arguments.length)throw Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
this.files={};this.comment=null;this.root="";this.clone=function(){var b=new d,a;for(a in this)"function"!==typeof this[a]&&(b[a]=this[a]);return b}}d.prototype=b("./object");d.prototype.loadAsync=b("./load");d.support=b("./support");d.defaults=b("./defaults");d.version="3.1.5";d.loadAsync=function(b,a){return(new d).loadAsync(b,a)};d.external=b("./external");g.exports=d},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(b,g,c){function d(d){return new a.Promise(function(a,
b){var e=d.decompressed.getContentWorker().pipe(new f);e.on("error",function(a){b(a)}).on("end",function(){e.streamInfo.crc32!==d.decompressed.crc32?b(Error("Corrupted zip : CRC32 mismatch")):a()}).resume()})}var e=b("./utils"),a=b("./external"),h=b("./utf8"),e=b("./utils"),k=b("./zipEntries"),f=b("./stream/Crc32Probe"),q=b("./nodejsUtils");g.exports=function(b,p){var y=this;p=e.extend(p||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:h.utf8decode});return q.isNode&&
q.isStream(b)?a.Promise.reject(Error("JSZip can't accept a stream when loading a zip file.")):e.prepareContent("the loaded zip file",b,!0,p.optimizedBinaryString,p.base64).then(function(a){var d=new k(p);d.load(a);return d}).then(function(b){var e=[a.Promise.resolve(b)];b=b.files;if(p.checkCRC32)for(var y=0;y<b.length;y++)e.push(d(b[y]));return a.Promise.all(e)}).then(function(a){a=a.shift();for(var d=a.files,b=0;b<d.length;b++){var w=d[b];y.file(w.fileNameStr,w.decompressed,{binary:!0,optimizedBinaryString:!0,
date:w.date,dir:w.dir,comment:w.fileCommentStr.length?w.fileCommentStr:null,unixPermissions:w.unixPermissions,dosPermissions:w.dosPermissions,createFolders:p.createFolders})}a.zipComment.length&&(y.comment=a.zipComment);return y})}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(b,g,c){function d(a,d){e.call(this,"Nodejs stream input adapter for "+a);this._upstreamEnded=!1;this._bindStream(d)}c=b("../utils");var e=b("../stream/GenericWorker");
c.inherits(d,e);d.prototype._bindStream=function(a){var d=this;this._stream=a;a.pause();a.on("data",function(a){d.push({data:a,meta:{percent:0}})}).on("error",function(a){d.isPaused?this.generatedError=a:d.error(a)}).on("end",function(){d.isPaused?d._upstreamEnded=!0:d.end()})};d.prototype.pause=function(){if(!e.prototype.pause.call(this))return!1;this._stream.pause();return!0};d.prototype.resume=function(){if(!e.prototype.resume.call(this))return!1;this._upstreamEnded?this.end():this._stream.resume();
return!0};g.exports=d},{"../stream/GenericWorker":28,"../utils":32}],13:[function(b,g,c){function d(a,d,b){e.call(this,d);this._helper=a;var c=this;a.on("data",function(a,d){c.push(a)||c._helper.pause();b&&b(d)}).on("error",function(a){c.emit("error",a)}).on("end",function(){c.push(null)})}var e=b("readable-stream").Readable;b("../utils").inherits(d,e);d.prototype._read=function(){this._helper.resume()};g.exports=d},{"../utils":32,"readable-stream":16}],14:[function(b,g,c){g.exports={isNode:"undefined"!==
typeof Buffer,newBufferFrom:function(d,b){return new Buffer(d,b)},allocBuffer:function(d){return Buffer.alloc?Buffer.alloc(d):new Buffer(d)},isBuffer:function(d){return Buffer.isBuffer(d)},isStream:function(d){return d&&"function"===typeof d.on&&"function"===typeof d.pause&&"function"===typeof d.resume}}},{}],15:[function(b,g,c){var d=b("./utf8"),e=b("./utils"),a=b("./stream/GenericWorker"),h=b("./stream/StreamHelper"),k=b("./defaults"),f=b("./compressedObject"),q=b("./zipObject"),A=b("./generate"),
p=b("./nodejsUtils"),y=b("./nodejs/NodejsStreamInputAdapter"),G=function(d,b,r){var h=e.getTypeOf(b),t,c=e.extend(r||{},k);c.date=c.date||new Date;null!==c.compression&&(c.compression=c.compression.toUpperCase());"string"===typeof c.unixPermissions&&(c.unixPermissions=parseInt(c.unixPermissions,8));c.unixPermissions&&c.unixPermissions&16384&&(c.dir=!0);c.dosPermissions&&c.dosPermissions&16&&(c.dir=!0);c.dir&&(d=F(d));var A;if(A=c.createFolders)t=d,"/"===t.slice(-1)&&(t=t.substring(0,t.length-1)),
A=t.lastIndexOf("/"),A=t=0<A?t.substring(0,A):"";A&&C.call(this,t,!0);h="string"===h&&!1===c.binary&&!1===c.base64;r&&"undefined"!==typeof r.binary||(c.binary=!h);if(b instanceof f&&0===b.uncompressedSize||c.dir||!b||0===b.length)c.base64=!1,c.binary=!0,b="",c.compression="STORE";r=null;r=b instanceof f||b instanceof a?b:p.isNode&&p.isStream(b)?new y(d,b):e.prepareContent(d,b,c.binary,c.optimizedBinaryString,c.base64);b=new q(d,r,c);this.files[d]=b},F=function(a){"/"!==a.slice(-1)&&(a+="/");return a},
C=function(a,d){d="undefined"!==typeof d?d:k.createFolders;a=F(a);this.files[a]||G.call(this,a,null,{dir:!0,createFolders:d});return this.files[a]};g.exports={load:function(){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},forEach:function(a){var d,b,p;for(d in this.files)this.files.hasOwnProperty(d)&&(p=this.files[d],(b=d.slice(this.root.length,d.length))&&d.slice(0,this.root.length)===this.root&&a(b,p))},filter:function(a){var d=[];this.forEach(function(b,
p){a(b,p)&&d.push(p)});return d},file:function(a,d,b){if(1===arguments.length){if("[object RegExp]"===Object.prototype.toString.call(a)){var p=a;return this.filter(function(a,t){return!t.dir&&p.test(a)})}var t=this.files[this.root+a];return t&&!t.dir?t:null}a=this.root+a;G.call(this,a,d,b);return this},folder:function(a){if(!a)return this;if("[object RegExp]"===Object.prototype.toString.call(a))return this.filter(function(d,t){return t.dir&&a.test(d)});var d=C.call(this,this.root+a),b=this.clone();
b.root=d.name;return b},remove:function(a){a=this.root+a;var d=this.files[a];d||("/"!==a.slice(-1)&&(a+="/"),d=this.files[a]);if(d&&!d.dir)delete this.files[a];else for(var d=this.filter(function(d,t){return t.name.slice(0,a.length)===a}),b=0;b<d.length;b++)delete this.files[d[b].name];return this},generate:function(a){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},generateInternalStream:function(b){var p,r={};try{r=e.extend(b||{},{streamFiles:!1,compression:"STORE",
compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:d.utf8encode});r.type=r.type.toLowerCase();r.compression=r.compression.toUpperCase();"binarystring"===r.type&&(r.type="string");if(!r.type)throw Error("No output type specified.");e.checkSupport(r.type);if("darwin"===r.platform||"freebsd"===r.platform||"linux"===r.platform||"sunos"===r.platform)r.platform="UNIX";"win32"===r.platform&&(r.platform="DOS");p=A.generateWorker(this,r,r.comment||this.comment||
"")}catch(y){p=new a("error"),p.error(y)}return new h(p,r.type||"string",r.mimeType)},generateAsync:function(a,d){return this.generateInternalStream(a).accumulate(d)},generateNodeStream:function(a,d){a=a||{};a.type||(a.type="nodebuffer");return this.generateInternalStream(a).toNodejsStream(d)}}},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],
16:[function(b,g,c){g.exports=b("stream")},{stream:void 0}],17:[function(b,g,c){function d(a){e.call(this,a);for(var d=0;d<this.data.length;d++)a[d]&=255}var e=b("./DataReader");b("../utils").inherits(d,e);d.prototype.byteAt=function(a){return this.data[this.zero+a]};d.prototype.lastIndexOfSignature=function(a){var d=a.charCodeAt(0),b=a.charCodeAt(1),e=a.charCodeAt(2);a=a.charCodeAt(3);for(var c=this.length-4;0<=c;--c)if(this.data[c]===d&&this.data[c+1]===b&&this.data[c+2]===e&&this.data[c+3]===a)return c-
this.zero;return-1};d.prototype.readAndCheckSignature=function(a){var d=a.charCodeAt(0),b=a.charCodeAt(1),e=a.charCodeAt(2);a=a.charCodeAt(3);var c=this.readData(4);return d===c[0]&&b===c[1]&&e===c[2]&&a===c[3]};d.prototype.readData=function(a){this.checkOffset(a);if(0===a)return[];var d=this.data.slice(this.zero+this.index,this.zero+this.index+a);this.index+=a;return d};g.exports=d},{"../utils":32,"./DataReader":18}],18:[function(b,g,c){function d(a){this.data=a;this.length=a.length;this.zero=this.index=
0}var e=b("../utils");d.prototype={checkOffset:function(a){this.checkIndex(this.index+a)},checkIndex:function(a){if(this.length<this.zero+a||0>a)throw Error("End of data reached (data length = "+this.length+", asked index = "+a+"). Corrupted zip ?");},setIndex:function(a){this.checkIndex(a);this.index=a},skip:function(a){this.setIndex(this.index+a)},byteAt:function(a){},readInt:function(a){var d=0,b;this.checkOffset(a);for(b=this.index+a-1;b>=this.index;b--)d=(d<<8)+this.byteAt(b);this.index+=a;return d},
readString:function(a){return e.transformTo("string",this.readData(a))},readData:function(a){},lastIndexOfSignature:function(a){},readAndCheckSignature:function(a){},readDate:function(){var a=this.readInt(4);return new Date(Date.UTC((a>>25&127)+1980,(a>>21&15)-1,a>>16&31,a>>11&31,a>>5&63,(a&31)<<1))}};g.exports=d},{"../utils":32}],19:[function(b,g,c){function d(a){e.call(this,a)}var e=b("./Uint8ArrayReader");b("../utils").inherits(d,e);d.prototype.readData=function(a){this.checkOffset(a);var d=this.data.slice(this.zero+
this.index,this.zero+this.index+a);this.index+=a;return d};g.exports=d},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(b,g,c){function d(a){e.call(this,a)}var e=b("./DataReader");b("../utils").inherits(d,e);d.prototype.byteAt=function(a){return this.data.charCodeAt(this.zero+a)};d.prototype.lastIndexOfSignature=function(a){return this.data.lastIndexOf(a)-this.zero};d.prototype.readAndCheckSignature=function(a){var d=this.readData(4);return a===d};d.prototype.readData=function(a){this.checkOffset(a);
var d=this.data.slice(this.zero+this.index,this.zero+this.index+a);this.index+=a;return d};g.exports=d},{"../utils":32,"./DataReader":18}],21:[function(b,g,c){function d(a){e.call(this,a)}var e=b("./ArrayReader");b("../utils").inherits(d,e);d.prototype.readData=function(a){this.checkOffset(a);if(0===a)return new Uint8Array(0);var d=this.data.subarray(this.zero+this.index,this.zero+this.index+a);this.index+=a;return d};g.exports=d},{"../utils":32,"./ArrayReader":17}],22:[function(b,g,c){var d=b("../utils"),
e=b("../support"),a=b("./ArrayReader"),h=b("./StringReader"),k=b("./NodeBufferReader"),f=b("./Uint8ArrayReader");g.exports=function(b){var c=d.getTypeOf(b);d.checkSupport(c);return"string"!==c||e.uint8array?"nodebuffer"===c?new k(b):e.uint8array?new f(d.transformTo("uint8array",b)):new a(d.transformTo("array",b)):new h(b)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(b,g,c){c.LOCAL_FILE_HEADER="PK\u0003\u0004";
c.CENTRAL_FILE_HEADER="PK\u0001\u0002";c.CENTRAL_DIRECTORY_END="PK\u0005\u0006";c.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK\u0006\u0007";c.ZIP64_CENTRAL_DIRECTORY_END="PK\u0006\u0006";c.DATA_DESCRIPTOR="PK\u0007\b"},{}],24:[function(b,g,c){function d(a){e.call(this,"ConvertWorker to "+a);this.destType=a}var e=b("./GenericWorker"),a=b("../utils");a.inherits(d,e);d.prototype.processChunk=function(d){this.push({data:a.transformTo(this.destType,d.data),meta:d.meta})};g.exports=d},{"../utils":32,"./GenericWorker":28}],
25:[function(b,g,c){function d(){e.call(this,"Crc32Probe");this.withStreamInfo("crc32",0)}var e=b("./GenericWorker"),a=b("../crc32");b("../utils").inherits(d,e);d.prototype.processChunk=function(d){this.streamInfo.crc32=a(d.data,this.streamInfo.crc32||0);this.push(d)};g.exports=d},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(b,g,c){function d(a){e.call(this,"DataLengthProbe for "+a);this.propName=a;this.withStreamInfo(a,0)}c=b("../utils");var e=b("./GenericWorker");c.inherits(d,
e);d.prototype.processChunk=function(a){a&&(this.streamInfo[this.propName]=(this.streamInfo[this.propName]||0)+a.data.length);e.prototype.processChunk.call(this,a)};g.exports=d},{"../utils":32,"./GenericWorker":28}],27:[function(b,g,c){function d(d){a.call(this,"DataWorker");var b=this;this.dataIsReady=!1;this.max=this.index=0;this.data=null;this.type="";this._tickScheduled=!1;d.then(function(a){b.dataIsReady=!0;b.data=a;b.max=a&&a.length||0;b.type=e.getTypeOf(a);b.isPaused||b._tickAndRepeat()},function(a){b.error(a)})}
var e=b("../utils"),a=b("./GenericWorker");e.inherits(d,a);d.prototype.cleanUp=function(){a.prototype.cleanUp.call(this);this.data=null};d.prototype.resume=function(){if(!a.prototype.resume.call(this))return!1;!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,e.delay(this._tickAndRepeat,[],this));return!0};d.prototype._tickAndRepeat=function(){this._tickScheduled=!1;this.isPaused||this.isFinished||(this._tick(),this.isFinished||(e.delay(this._tickAndRepeat,[],this),this._tickScheduled=
!0))};d.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var a=null,d=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case "string":a=this.data.substring(this.index,d);break;case "uint8array":a=this.data.subarray(this.index,d);break;case "array":case "nodebuffer":a=this.data.slice(this.index,d)}this.index=d;return this.push({data:a,meta:{percent:this.max?this.index/this.max*100:0}})};g.exports=d},{"../utils":32,"./GenericWorker":28}],
28:[function(b,g,c){function d(d){this.name=d||"default";this.streamInfo={};this.generatedError=null;this.extraStreamInfo={};this.isPaused=!0;this.isLocked=this.isFinished=!1;this._listeners={data:[],end:[],error:[]};this.previous=null}d.prototype={push:function(d){this.emit("data",d)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(d){this.emit("error",d)}return!0},error:function(d){if(this.isFinished)return!1;this.isPaused?this.generatedError=
d:(this.isFinished=!0,this.emit("error",d),this.previous&&this.previous.error(d),this.cleanUp());return!0},on:function(d,a){this._listeners[d].push(a);return this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null;this._listeners=[]},emit:function(d,a){if(this._listeners[d])for(var b=0;b<this._listeners[d].length;b++)this._listeners[d][b].call(this,a)},pipe:function(d){return d.registerPrevious(this)},registerPrevious:function(d){if(this.isLocked)throw Error("The stream '"+
this+"' has already been used.");this.streamInfo=d.streamInfo;this.mergeStreamInfo();this.previous=d;var a=this;d.on("data",function(d){a.processChunk(d)});d.on("end",function(){a.end()});d.on("error",function(d){a.error(d)});return this},pause:function(){if(this.isPaused||this.isFinished)return!1;this.isPaused=!0;this.previous&&this.previous.pause();return!0},resume:function(){if(!this.isPaused||this.isFinished)return!1;var d=this.isPaused=!1;this.generatedError&&(this.error(this.generatedError),
d=!0);this.previous&&this.previous.resume();return!d},flush:function(){},processChunk:function(d){this.push(d)},withStreamInfo:function(d,a){this.extraStreamInfo[d]=a;this.mergeStreamInfo();return this},mergeStreamInfo:function(){for(var d in this.extraStreamInfo)this.extraStreamInfo.hasOwnProperty(d)&&(this.streamInfo[d]=this.extraStreamInfo[d])},lock:function(){if(this.isLocked)throw Error("The stream '"+this+"' has already been used.");this.isLocked=!0;this.previous&&this.previous.lock()},toString:function(){var d=
"Worker "+this.name;return this.previous?this.previous+" -> "+d:d}};g.exports=d},{}],29:[function(b,g,c){function d(d,a){var b,p=0,c=null;for(b=c=0;b<a.length;b++)c+=a[b].length;switch(d){case "string":return a.join("");case "array":return Array.prototype.concat.apply([],a);case "uint8array":c=new Uint8Array(c);for(b=0;b<a.length;b++)c.set(a[b],p),p+=a[b].length;return c;case "nodebuffer":return Buffer.concat(a);default:throw Error("concat : unsupported type '"+d+"'");}}function e(a,b){return new A.Promise(function(p,
c){var e=[],f=a._internalType,r=a._outputType,k=a._mimeType;a.on("data",function(a,d){e.push(a);b&&b(d)}).on("error",function(a){e=[];c(a)}).on("end",function(){try{var a;a:{var b=d(f,e);switch(r){case "blob":a=h.newBlob(h.transformTo("arraybuffer",b),k);break a;case "base64":a=q.encode(b);break a;default:a=h.transformTo(r,b)}}p(a)}catch(y){c(y)}e=[]}).resume()})}function a(a,d,b){var p=d;switch(d){case "blob":case "arraybuffer":p="uint8array";break;case "base64":p="string"}try{this._internalType=
p,this._outputType=d,this._mimeType=b,h.checkSupport(p),this._worker=a.pipe(new k(p)),a.lock()}catch(c){this._worker=new f("error"),this._worker.error(c)}}var h=b("../utils"),k=b("./ConvertWorker"),f=b("./GenericWorker"),q=b("../base64");c=b("../support");var A=b("../external"),p=null;if(c.nodestream)try{p=b("../nodejs/NodejsStreamOutputAdapter")}catch(y){}a.prototype={accumulate:function(a){return e(this,a)},on:function(a,d){var b=this;if("data"===a)this._worker.on(a,function(a){d.call(b,a.data,
a.meta)});else this._worker.on(a,function(){h.delay(d,arguments,b)});return this},resume:function(){h.delay(this._worker.resume,[],this._worker);return this},pause:function(){this._worker.pause();return this},toNodejsStream:function(a){h.checkSupport("nodestream");if("nodebuffer"!==this._outputType)throw Error(this._outputType+" is not supported by this method");return new p(this,{objectMode:"nodebuffer"!==this._outputType},a)}};g.exports=a},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,
"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(b,g,c){c.base64=!0;c.array=!0;c.string=!0;c.arraybuffer="undefined"!==typeof ArrayBuffer&&"undefined"!==typeof Uint8Array;c.nodebuffer="undefined"!==typeof Buffer;c.uint8array="undefined"!==typeof Uint8Array;if("undefined"===typeof ArrayBuffer)c.blob=!1;else{g=new ArrayBuffer(0);try{c.blob=0===(new Blob([g],{type:"application/zip"})).size}catch(e){try{var d=new (self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||
self.MSBlobBuilder);d.append(g);c.blob=0===d.getBlob("application/zip").size}catch(a){c.blob=!1}}}try{c.nodestream=!!b("readable-stream").Readable}catch(e){c.nodestream=!1}},{"readable-stream":16}],31:[function(b,g,c){function d(){f.call(this,"utf-8 decode");this.leftOver=null}function e(){f.call(this,"utf-8 encode")}var a=b("./utils"),h=b("./support"),k=b("./nodejsUtils"),f=b("./stream/GenericWorker"),q=Array(256);for(b=0;256>b;b++)q[b]=252<=b?6:248<=b?5:240<=b?4:224<=b?3:192<=b?2:1;q[254]=q[254]=
1;c.utf8encode=function(a){if(h.nodebuffer)return k.newBufferFrom(a,"utf-8");var d,b,c,e,q,w=a.length,f=0;for(e=0;e<w;e++)b=a.charCodeAt(e),55296===(b&64512)&&e+1<w&&(c=a.charCodeAt(e+1),56320===(c&64512)&&(b=65536+(b-55296<<10)+(c-56320),e++)),f+=128>b?1:2048>b?2:65536>b?3:4;d=h.uint8array?new Uint8Array(f):Array(f);for(e=q=0;q<f;e++)b=a.charCodeAt(e),55296===(b&64512)&&e+1<w&&(c=a.charCodeAt(e+1),56320===(c&64512)&&(b=65536+(b-55296<<10)+(c-56320),e++)),128>b?d[q++]=b:(2048>b?d[q++]=192|b>>>6:(65536>
b?d[q++]=224|b>>>12:(d[q++]=240|b>>>18,d[q++]=128|b>>>12&63),d[q++]=128|b>>>6&63),d[q++]=128|b&63);return d};c.utf8decode=function(d){if(h.nodebuffer)return a.transformTo("nodebuffer",d).toString("utf-8");d=a.transformTo(h.uint8array?"uint8array":"array",d);var b,c,e,f,k=d.length,w=Array(2*k);for(b=c=0;b<k;)if(e=d[b++],128>e)w[c++]=e;else if(f=q[e],4<f)w[c++]=65533,b+=f-1;else{for(e&=2===f?31:3===f?15:7;1<f&&b<k;)e=e<<6|d[b++]&63,f--;1<f?w[c++]=65533:65536>e?w[c++]=e:(e-=65536,w[c++]=55296|e>>10&
1023,w[c++]=56320|e&1023)}w.length!==c&&(w.subarray?w=w.subarray(0,c):w.length=c);return a.applyFromCharCode(w)};a.inherits(d,f);d.prototype.processChunk=function(d){var b=a.transformTo(h.uint8array?"uint8array":"array",d.data);if(this.leftOver&&this.leftOver.length){if(h.uint8array){var e=b,b=new Uint8Array(e.length+this.leftOver.length);b.set(this.leftOver,0);b.set(e,this.leftOver.length)}else b=this.leftOver.concat(b);this.leftOver=null}var f,e=b.length;e>b.length&&(e=b.length);for(f=e-1;0<=f&&
128===(b[f]&192);)f--;e=0>f?e:0===f?e:f+q[b[f]]>e?f:e;f=b;e!==b.length&&(h.uint8array?(f=b.subarray(0,e),this.leftOver=b.subarray(e,b.length)):(f=b.slice(0,e),this.leftOver=b.slice(e,b.length)));this.push({data:c.utf8decode(f),meta:d.meta})};d.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:c.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)};c.Utf8DecodeWorker=d;a.inherits(e,f);e.prototype.processChunk=function(a){this.push({data:c.utf8encode(a.data),meta:a.meta})};
c.Utf8EncodeWorker=e},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(b,g,c){function d(a){return a}function e(a,d){for(var b=0;b<a.length;++b)d[b]=a.charCodeAt(b)&255;return d}function a(a){var d=65536,b=c.getTypeOf(a),e=!0;"uint8array"===b?e=F.applyCanBeUsed.uint8array:"nodebuffer"===b&&(e=F.applyCanBeUsed.nodebuffer);if(e)for(;1<d;)try{return F.stringifyByChunk(a,b,d)}catch(t){d=Math.floor(d/2)}return F.stringifyByChar(a)}function h(a,d){for(var b=0;b<
a.length;b++)d[b]=a[b];return d}var k=b("./support"),f=b("./base64"),q=b("./nodejsUtils"),A=b("core-js/library/fn/set-immediate"),p=b("./external");c.newBlob=function(a,d){c.checkSupport("blob");try{return new Blob([a],{type:d})}catch(b){try{var e=new (self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);e.append(a);return e.getBlob(d)}catch(t){throw Error("Bug : can't construct the Blob.");}}};var y;try{y=k.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(w){y=
!1}b=y;var G;try{G=k.nodebuffer&&1===String.fromCharCode.apply(null,q.allocBuffer(1)).length}catch(w){G=!1}var F={stringifyByChunk:function(a,d,b){var c=[],t=0,e=a.length;if(e<=b)return String.fromCharCode.apply(null,a);for(;t<e;)"array"===d||"nodebuffer"===d?c.push(String.fromCharCode.apply(null,a.slice(t,Math.min(t+b,e)))):c.push(String.fromCharCode.apply(null,a.subarray(t,Math.min(t+b,e)))),t+=b;return c.join("")},stringifyByChar:function(a){for(var d="",b=0;b<a.length;b++)d+=String.fromCharCode(a[b]);
return d},applyCanBeUsed:{uint8array:b,nodebuffer:G}};c.applyFromCharCode=a;var C={};C.string={string:d,array:function(a){return e(a,Array(a.length))},arraybuffer:function(a){return C.string.uint8array(a).buffer},uint8array:function(a){return e(a,new Uint8Array(a.length))},nodebuffer:function(a){return e(a,q.allocBuffer(a.length))}};C.array={string:a,array:d,arraybuffer:function(a){return(new Uint8Array(a)).buffer},uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return q.newBufferFrom(a)}};
C.arraybuffer={string:function(d){return a(new Uint8Array(d))},array:function(a){return h(new Uint8Array(a),Array(a.byteLength))},arraybuffer:d,uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return q.newBufferFrom(new Uint8Array(a))}};C.uint8array={string:a,array:function(a){return h(a,Array(a.length))},arraybuffer:function(a){return a.buffer},uint8array:d,nodebuffer:function(a){return q.newBufferFrom(a)}};C.nodebuffer={string:a,array:function(a){return h(a,Array(a.length))},
arraybuffer:function(a){return C.nodebuffer.uint8array(a).buffer},uint8array:function(a){return h(a,new Uint8Array(a.length))},nodebuffer:d};c.transformTo=function(a,d){d||(d="");if(!a)return d;c.checkSupport(a);var b=c.getTypeOf(d);return C[b][a](d)};c.getTypeOf=function(a){if("string"===typeof a)return"string";if("[object Array]"===Object.prototype.toString.call(a))return"array";if(k.nodebuffer&&q.isBuffer(a))return"nodebuffer";if(k.uint8array&&a instanceof Uint8Array)return"uint8array";if(k.arraybuffer&&
a instanceof ArrayBuffer)return"arraybuffer"};c.checkSupport=function(a){if(!k[a.toLowerCase()])throw Error(a+" is not supported by this platform");};c.MAX_VALUE_16BITS=65535;c.MAX_VALUE_32BITS=-1;c.pretty=function(a){var d="",b,c;for(c=0;c<(a||"").length;c++)b=a.charCodeAt(c),d+="\\x"+(16>b?"0":"")+b.toString(16).toUpperCase();return d};c.delay=function(a,d,b){A(function(){a.apply(b||null,d||[])})};c.inherits=function(a,d){var b=function(){};b.prototype=d.prototype;a.prototype=new b};c.extend=function(){var a=
{},d,b;for(d=0;d<arguments.length;d++)for(b in arguments[d])arguments[d].hasOwnProperty(b)&&"undefined"===typeof a[b]&&(a[b]=arguments[d][b]);return a};c.prepareContent=function(a,d,b,q,t){return p.Promise.resolve(d).then(function(a){return k.blob&&(a instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(a)))&&"undefined"!==typeof FileReader?new p.Promise(function(d,b){var t=new FileReader;t.onload=function(a){d(a.target.result)};t.onerror=function(a){b(a.target.error)};
t.readAsArrayBuffer(a)}):a}).then(function(d){var h=c.getTypeOf(d);if(!h)return p.Promise.reject(Error("Can't read the data of '"+a+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"));"arraybuffer"===h?d=c.transformTo("uint8array",d):"string"===h&&(t?d=f.decode(d):b&&!0!==q&&(h=null,h=k.uint8array?new Uint8Array(d.length):Array(d.length),d=e(d,h)));return d})}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,"core-js/library/fn/set-immediate":36}],33:[function(b,
g,c){function d(a){this.files=[];this.loadOptions=a}var e=b("./reader/readerFor"),a=b("./utils"),h=b("./signature"),k=b("./zipEntry");b("./utf8");var f=b("./support");d.prototype={checkSignature:function(d){if(!this.reader.readAndCheckSignature(d)){this.reader.index-=4;var b=this.reader.readString(4);throw Error("Corrupted zip or bug: unexpected signature ("+a.pretty(b)+", expected "+a.pretty(d)+")");}},isSignature:function(a,d){var b=this.reader.index;this.reader.setIndex(a);var c=this.reader.readString(4)===
d;this.reader.setIndex(b);return c},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2);this.diskWithCentralDirStart=this.reader.readInt(2);this.centralDirRecordsOnThisDisk=this.reader.readInt(2);this.centralDirRecords=this.reader.readInt(2);this.centralDirSize=this.reader.readInt(4);this.centralDirOffset=this.reader.readInt(4);this.zipCommentLength=this.reader.readInt(2);var d=this.reader.readData(this.zipCommentLength),d=a.transformTo(f.uint8array?"uint8array":"array",d);this.zipComment=
this.loadOptions.decodeFileName(d)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8);this.reader.skip(4);this.diskNumber=this.reader.readInt(4);this.diskWithCentralDirStart=this.reader.readInt(4);this.centralDirRecordsOnThisDisk=this.reader.readInt(8);this.centralDirRecords=this.reader.readInt(8);this.centralDirSize=this.reader.readInt(8);this.centralDirOffset=this.reader.readInt(8);this.zip64ExtensibleData={};for(var a=this.zip64EndOfCentralSize-44,d,b,c;0<
a;)d=this.reader.readInt(2),b=this.reader.readInt(4),c=this.reader.readData(b),this.zip64ExtensibleData[d]={id:d,length:b,value:c}},readBlockZip64EndOfCentralLocator:function(){this.diskWithZip64CentralDirStart=this.reader.readInt(4);this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8);this.disksCount=this.reader.readInt(4);if(1<this.disksCount)throw Error("Multi-volumes zip are not supported");},readLocalFiles:function(){var a,d;for(a=0;a<this.files.length;a++)d=this.files[a],this.reader.setIndex(d.localHeaderOffset),
this.checkSignature(h.LOCAL_FILE_HEADER),d.readLocalPart(this.reader),d.handleUTF8(),d.processAttributes()},readCentralDir:function(){var a;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(h.CENTRAL_FILE_HEADER);)a=new k({zip64:this.zip64},this.loadOptions),a.readCentralPart(this.reader),this.files.push(a);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw Error("Corrupted zip or bug: expected "+this.centralDirRecords+
" records in central dir, got "+this.files.length);},readEndOfCentral:function(){var d=this.reader.lastIndexOfSignature(h.CENTRAL_DIRECTORY_END);if(0>d){if(this.isSignature(0,h.LOCAL_FILE_HEADER))throw Error("Corrupted zip: can't find end of central directory");throw Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");}this.reader.setIndex(d);var b=d;this.checkSignature(h.CENTRAL_DIRECTORY_END);this.readBlockEndOfCentral();
if(this.diskNumber===a.MAX_VALUE_16BITS||this.diskWithCentralDirStart===a.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===a.MAX_VALUE_16BITS||this.centralDirRecords===a.MAX_VALUE_16BITS||this.centralDirSize===a.MAX_VALUE_32BITS||this.centralDirOffset===a.MAX_VALUE_32BITS){this.zip64=!0;d=this.reader.lastIndexOfSignature(h.ZIP64_CENTRAL_DIRECTORY_LOCATOR);if(0>d)throw Error("Corrupted zip: can't find the ZIP64 end of central directory locator");this.reader.setIndex(d);this.checkSignature(h.ZIP64_CENTRAL_DIRECTORY_LOCATOR);
this.readBlockZip64EndOfCentralLocator();if(!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,h.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(h.ZIP64_CENTRAL_DIRECTORY_END),0>this.relativeOffsetEndOfZip64CentralDir))throw Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);this.checkSignature(h.ZIP64_CENTRAL_DIRECTORY_END);this.readBlockZip64EndOfCentral()}d=
this.centralDirOffset+this.centralDirSize;this.zip64&&(d=d+20+(12+this.zip64EndOfCentralSize));d=b-d;if(0<d)this.isSignature(b,h.CENTRAL_FILE_HEADER)||(this.reader.zero=d);else if(0>d)throw Error("Corrupted zip: missing "+Math.abs(d)+" bytes.");},prepareReader:function(a){this.reader=e(a)},load:function(a){this.prepareReader(a);this.readEndOfCentral();this.readCentralDir();this.readLocalFiles()}};g.exports=d},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utf8":31,"./utils":32,"./zipEntry":34}],
34:[function(b,g,c){function d(a,d){this.options=a;this.loadOptions=d}var e=b("./reader/readerFor"),a=b("./utils"),h=b("./compressedObject"),k=b("./crc32"),f=b("./utf8"),q=b("./compressions"),A=b("./support");d.prototype={isEncrypted:function(){return 1===(this.bitFlag&1)},useUTF8:function(){return 2048===(this.bitFlag&2048)},readLocalPart:function(d){var b,c;d.skip(22);this.fileNameLength=d.readInt(2);c=d.readInt(2);this.fileName=d.readData(this.fileNameLength);d.skip(c);if(-1===this.compressedSize||
-1===this.uncompressedSize)throw Error("Bug or corrupted zip : didn't get enough informations from the central directory (compressedSize === -1 || uncompressedSize === -1)");a:{c=this.compressionMethod;for(b in q)if(q.hasOwnProperty(b)&&q[b].magic===c){b=q[b];break a}b=null}if(null===b)throw Error("Corrupted zip : compression "+a.pretty(this.compressionMethod)+" unknown (inner file : "+a.transformTo("string",this.fileName)+")");this.decompressed=new h(this.compressedSize,this.uncompressedSize,this.crc32,
b,d.readData(this.compressedSize))},readCentralPart:function(a){this.versionMadeBy=a.readInt(2);a.skip(2);this.bitFlag=a.readInt(2);this.compressionMethod=a.readString(2);this.date=a.readDate();this.crc32=a.readInt(4);this.compressedSize=a.readInt(4);this.uncompressedSize=a.readInt(4);var d=a.readInt(2);this.extraFieldsLength=a.readInt(2);this.fileCommentLength=a.readInt(2);this.diskNumberStart=a.readInt(2);this.internalFileAttributes=a.readInt(2);this.externalFileAttributes=a.readInt(4);this.localHeaderOffset=
a.readInt(4);if(this.isEncrypted())throw Error("Encrypted zip are not supported");a.skip(d);this.readExtraFields(a);this.parseZIP64ExtraField(a);this.fileComment=a.readData(this.fileCommentLength)},processAttributes:function(){this.dosPermissions=this.unixPermissions=null;var a=this.versionMadeBy>>8;this.dir=this.externalFileAttributes&16?!0:!1;0===a&&(this.dosPermissions=this.externalFileAttributes&63);3===a&&(this.unixPermissions=this.externalFileAttributes>>16&65535);this.dir||"/"!==this.fileNameStr.slice(-1)||
(this.dir=!0)},parseZIP64ExtraField:function(d){this.extraFields[1]&&(d=e(this.extraFields[1].value),this.uncompressedSize===a.MAX_VALUE_32BITS&&(this.uncompressedSize=d.readInt(8)),this.compressedSize===a.MAX_VALUE_32BITS&&(this.compressedSize=d.readInt(8)),this.localHeaderOffset===a.MAX_VALUE_32BITS&&(this.localHeaderOffset=d.readInt(8)),this.diskNumberStart===a.MAX_VALUE_32BITS&&(this.diskNumberStart=d.readInt(4)))},readExtraFields:function(a){var d=a.index+this.extraFieldsLength,b,c,e;this.extraFields||
(this.extraFields={});for(;a.index<d;)b=a.readInt(2),c=a.readInt(2),e=a.readData(c),this.extraFields[b]={id:b,length:c,value:e}},handleUTF8:function(){var d=A.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=f.utf8decode(this.fileName),this.fileCommentStr=f.utf8decode(this.fileComment);else{var b=this.findExtraFieldUnicodePath();null!==b?this.fileNameStr=b:(b=a.transformTo(d,this.fileName),this.fileNameStr=this.loadOptions.decodeFileName(b));b=this.findExtraFieldUnicodeComment();
null!==b?this.fileCommentStr=b:(d=a.transformTo(d,this.fileComment),this.fileCommentStr=this.loadOptions.decodeFileName(d))}},findExtraFieldUnicodePath:function(){var a=this.extraFields[28789];if(a){var d=e(a.value);return 1!==d.readInt(1)||k(this.fileName)!==d.readInt(4)?null:f.utf8decode(d.readData(a.length-5))}return null},findExtraFieldUnicodeComment:function(){var a=this.extraFields[25461];if(a){var d=e(a.value);return 1!==d.readInt(1)||k(this.fileComment)!==d.readInt(4)?null:f.utf8decode(d.readData(a.length-
5))}return null}};g.exports=d},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(b,g,c){var d=b("./stream/StreamHelper"),e=b("./stream/DataWorker"),a=b("./utf8"),h=b("./compressedObject"),k=b("./stream/GenericWorker");b=function(a,d,b){this.name=a;this.dir=b.dir;this.date=b.date;this.comment=b.comment;this.unixPermissions=b.unixPermissions;this.dosPermissions=b.dosPermissions;this._data=d;this._dataBinary=b.binary;
this.options={compression:b.compression,compressionOptions:b.compressionOptions}};b.prototype={internalStream:function(b){var c=null,e="string";try{if(!b)throw Error("No output type specified.");e=b.toLowerCase();b="string"===e||"text"===e;if("binarystring"===e||"text"===e)e="string";var c=this._decompressWorker(),f=!this._dataBinary;f&&!b&&(c=c.pipe(new a.Utf8EncodeWorker));!f&&b&&(c=c.pipe(new a.Utf8DecodeWorker))}catch(h){c=new k("error"),c.error(h)}return new d(c,e,"")},async:function(a,d){return this.internalStream(a).accumulate(d)},
nodeStream:function(a,d){return this.internalStream(a||"nodebuffer").toNodejsStream(d)},_compressWorker:function(d,b){if(this._data instanceof h&&this._data.compression.magic===d.magic)return this._data.getCompressedWorker();var c=this._decompressWorker();this._dataBinary||(c=c.pipe(new a.Utf8EncodeWorker));return h.createWorkerFrom(c,d,b)},_decompressWorker:function(){return this._data instanceof h?this._data.getContentWorker():this._data instanceof k?this._data:new e(this._data)}};c=["asText","asBinary",
"asNodeBuffer","asUint8Array","asArrayBuffer"];for(var f=function(){throw Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");},q=0;q<c.length;q++)b.prototype[c[q]]=f;g.exports=b},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(b,g,c){b("../modules/web.immediate");g.exports=b("../modules/_core").setImmediate},{"../modules/_core":40,"../modules/web.immediate":56}],37:[function(b,g,c){g.exports=
function(d){if("function"!=typeof d)throw TypeError(d+" is not a function!");return d}},{}],38:[function(b,g,c){var d=b("./_is-object");g.exports=function(b){if(!d(b))throw TypeError(b+" is not an object!");return b}},{"./_is-object":51}],39:[function(b,g,c){var d={}.toString;g.exports=function(b){return d.call(b).slice(8,-1)}},{}],40:[function(b,g,c){b=g.exports={version:"2.3.0"};"number"==typeof __e&&(__e=b)},{}],41:[function(b,g,c){var d=b("./_a-function");g.exports=function(b,a,c){d(b);if(void 0===
a)return b;switch(c){case 1:return function(d){return b.call(a,d)};case 2:return function(d,c){return b.call(a,d,c)};case 3:return function(d,c,h){return b.call(a,d,c,h)}}return function(){return b.apply(a,arguments)}}},{"./_a-function":37}],42:[function(b,g,c){g.exports=!b("./_fails")(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a})},{"./_fails":45}],43:[function(b,g,c){c=b("./_is-object");var d=b("./_global").document,e=c(d)&&c(d.createElement);g.exports=function(a){return e?
d.createElement(a):{}}},{"./_global":46,"./_is-object":51}],44:[function(b,g,c){var d=b("./_global"),e=b("./_core"),a=b("./_ctx"),h=b("./_hide"),k=function(b,c,g){var p=b&k.F,y=b&k.G,G=b&k.S,F=b&k.P,C=b&k.B,w=b&k.W,x=y?e:e[c]||(e[c]={}),r=x.prototype,G=y?d:G?d[c]:(d[c]||{}).prototype,K,t;y&&(g=c);for(K in g)c=!p&&G&&void 0!==G[K],c&&K in x||(t=c?G[K]:g[K],x[K]=y&&"function"!=typeof G[K]?g[K]:C&&c?a(t,d):w&&G[K]==t?function(a){var d=function(d,b,t){if(this instanceof a){switch(arguments.length){case 0:return new a;
case 1:return new a(d);case 2:return new a(d,b)}return new a(d,b,t)}return a.apply(this,arguments)};d.prototype=a.prototype;return d}(t):F&&"function"==typeof t?a(Function.call,t):t,F&&((x.virtual||(x.virtual={}))[K]=t,b&k.R&&r&&!r[K]&&h(r,K,t)))};k.F=1;k.G=2;k.S=4;k.P=8;k.B=16;k.W=32;k.U=64;k.R=128;g.exports=k},{"./_core":40,"./_ctx":41,"./_global":46,"./_hide":47}],45:[function(b,g,c){g.exports=function(d){try{return!!d()}catch(b){return!0}}},{}],46:[function(b,g,c){b=g.exports="undefined"!=typeof window&&
window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=b)},{}],47:[function(b,g,c){var d=b("./_object-dp"),e=b("./_property-desc");g.exports=b("./_descriptors")?function(a,b,c){return d.f(a,b,e(1,c))}:function(a,d,b){a[d]=b;return a}},{"./_descriptors":42,"./_object-dp":52,"./_property-desc":53}],48:[function(b,g,c){g.exports=b("./_global").document&&document.documentElement},{"./_global":46}],49:[function(b,g,c){g.exports=!b("./_descriptors")&&
!b("./_fails")(function(){return 7!=Object.defineProperty(b("./_dom-create")("div"),"a",{get:function(){return 7}}).a})},{"./_descriptors":42,"./_dom-create":43,"./_fails":45}],50:[function(b,g,c){g.exports=function(d,b,a){var c=void 0===a;switch(b.length){case 0:return c?d():d.call(a);case 1:return c?d(b[0]):d.call(a,b[0]);case 2:return c?d(b[0],b[1]):d.call(a,b[0],b[1]);case 3:return c?d(b[0],b[1],b[2]):d.call(a,b[0],b[1],b[2]);case 4:return c?d(b[0],b[1],b[2],b[3]):d.call(a,b[0],b[1],b[2],b[3])}return d.apply(a,
b)}},{}],51:[function(b,g,c){g.exports=function(d){return"object"===typeof d?null!==d:"function"===typeof d}},{}],52:[function(b,g,c){var d=b("./_an-object"),e=b("./_ie8-dom-define"),a=b("./_to-primitive"),h=Object.defineProperty;c.f=b("./_descriptors")?Object.defineProperty:function(b,c,q){d(b);c=a(c,!0);d(q);if(e)try{return h(b,c,q)}catch(g){}if("get"in q||"set"in q)throw TypeError("Accessors not supported!");"value"in q&&(b[c]=q.value);return b}},{"./_an-object":38,"./_descriptors":42,"./_ie8-dom-define":49,
"./_to-primitive":55}],53:[function(b,g,c){g.exports=function(d,b){return{enumerable:!(d&1),configurable:!(d&2),writable:!(d&4),value:b}}},{}],54:[function(b,g,c){var d=b("./_ctx"),e=b("./_invoke"),a=b("./_html"),h=b("./_dom-create"),k=b("./_global"),f=k.process;c=k.setImmediate;var q=k.clearImmediate,A=k.MessageChannel,p=0,y={},G,F=function(){var a=+this;if(y.hasOwnProperty(a)){var d=y[a];delete y[a];d()}},C=function(a){F.call(a.data)};c&&q||(c=function(a){for(var d=[],b=1;arguments.length>b;)d.push(arguments[b++]);
y[++p]=function(){e("function"==typeof a?a:Function(a),d)};G(p);return p},q=function(a){delete y[a]},"process"==b("./_cof")(f)?G=function(a){f.nextTick(d(F,a,1))}:A?(b=new A,A=b.port2,b.port1.onmessage=C,G=d(A.postMessage,A,1)):k.addEventListener&&"function"==typeof postMessage&&!k.importScripts?(G=function(a){k.postMessage(a+"","*")},k.addEventListener("message",C,!1)):G="onreadystatechange"in h("script")?function(d){a.appendChild(h("script")).onreadystatechange=function(){a.removeChild(this);F.call(d)}}:
function(a){setTimeout(d(F,a,1),0)});g.exports={set:c,clear:q}},{"./_cof":39,"./_ctx":41,"./_dom-create":43,"./_global":46,"./_html":48,"./_invoke":50}],55:[function(b,g,c){var d=b("./_is-object");g.exports=function(b,a){if(!d(b))return b;var c,k;if(a&&"function"==typeof(c=b.toString)&&!d(k=c.call(b))||"function"==typeof(c=b.valueOf)&&!d(k=c.call(b))||!a&&"function"==typeof(c=b.toString)&&!d(k=c.call(b)))return k;throw TypeError("Can't convert object to primitive value");}},{"./_is-object":51}],56:[function(b,
g,c){g=b("./_export");b=b("./_task");g(g.G+g.B,{setImmediate:b.set,clearImmediate:b.clear})},{"./_export":44,"./_task":54}],57:[function(b,g,c){(function(d){function b(){A=!0;for(var a,d,c=p.length;c;){d=p;p=[];for(a=-1;++a<c;)d[a]();c=p.length}A=!1}var a=d.MutationObserver||d.WebKitMutationObserver,c;if(a){var k=0,a=new a(b),f=d.document.createTextNode("");a.observe(f,{characterData:!0});c=function(){f.data=k=++k%2}}else if(d.setImmediate||"undefined"===typeof d.MessageChannel)c="document"in d&&
"onreadystatechange"in d.document.createElement("script")?function(){var a=d.document.createElement("script");a.onreadystatechange=function(){b();a.onreadystatechange=null;a.parentNode.removeChild(a);a=null};d.document.documentElement.appendChild(a)}:function(){setTimeout(b,0)};else{var q=new d.MessageChannel;q.port1.onmessage=b;c=function(){q.port2.postMessage(0)}}var A,p=[];g.exports=function(a){1!==p.push(a)||A||c()}}).call(this,"undefined"!==typeof global?global:"undefined"!==typeof self?self:
"undefined"!==typeof window?window:{})},{}],58:[function(b,g,c){function d(){}function e(a){if("function"!==typeof a)throw new TypeError("resolver must be a function");this.state=F;this.queue=[];this.outcome=void 0;a!==d&&f(this,a)}function a(a,d,b){this.promise=a;"function"===typeof d&&(this.onFulfilled=d,this.callFulfilled=this.otherCallFulfilled);"function"===typeof b&&(this.onRejected=b,this.callRejected=this.otherCallRejected)}function h(a,d,b){A(function(){var c;try{c=d(b)}catch(e){return p.reject(a,
e)}c===a?p.reject(a,new TypeError("Cannot resolve promise with itself")):p.resolve(a,c)})}function k(a){var d=a&&a.then;if(a&&("object"===typeof a||"function"===typeof a)&&"function"===typeof d)return function(){d.apply(a,arguments)}}function f(a,d){function b(d){e||(e=!0,p.reject(a,d))}function c(d){e||(e=!0,p.resolve(a,d))}var e=!1,t=q(function(){d(c,b)});"error"===t.status&&b(t.value)}function q(a,d){var b={};try{b.value=a(d),b.status="success"}catch(c){b.status="error",b.value=c}return b}var A=
b("immediate"),p={},y=["REJECTED"],G=["FULFILLED"],F=["PENDING"];g.exports=e;e.prototype["catch"]=function(a){return this.then(null,a)};e.prototype.then=function(b,c){if("function"!==typeof b&&this.state===G||"function"!==typeof c&&this.state===y)return this;var e=new this.constructor(d);this.state!==F?h(e,this.state===G?b:c,this.outcome):this.queue.push(new a(e,b,c));return e};a.prototype.callFulfilled=function(a){p.resolve(this.promise,a)};a.prototype.otherCallFulfilled=function(a){h(this.promise,
this.onFulfilled,a)};a.prototype.callRejected=function(a){p.reject(this.promise,a)};a.prototype.otherCallRejected=function(a){h(this.promise,this.onRejected,a)};p.resolve=function(a,d){var b=q(k,d);if("error"===b.status)return p.reject(a,b.value);if(b=b.value)f(a,b);else{a.state=G;a.outcome=d;for(var b=-1,c=a.queue.length;++b<c;)a.queue[b].callFulfilled(d)}return a};p.reject=function(a,d){a.state=y;a.outcome=d;for(var b=-1,c=a.queue.length;++b<c;)a.queue[b].callRejected(d);return a};e.resolve=function(a){return a instanceof
this?a:p.resolve(new this(d),a)};e.reject=function(a){var b=new this(d);return p.reject(b,a)};e.all=function(a){function b(a,d){c.resolve(a).then(function(a){t[d]=a;++k!==e||f||(f=!0,p.resolve(q,t))},function(a){f||(f=!0,p.reject(q,a))})}var c=this;if("[object Array]"!==Object.prototype.toString.call(a))return this.reject(new TypeError("must be an array"));var e=a.length,f=!1;if(!e)return this.resolve([]);for(var t=Array(e),k=0,h=-1,q=new this(d);++h<e;)b(a[h],h);return q};e.race=function(a){function b(a){c.resolve(a).then(function(a){f||
(f=!0,p.resolve(k,a))},function(a){f||(f=!0,p.reject(k,a))})}var c=this;if("[object Array]"!==Object.prototype.toString.call(a))return this.reject(new TypeError("must be an array"));var e=a.length,f=!1;if(!e)return this.resolve([]);for(var t=-1,k=new this(d);++t<e;)b(a[t]);return k}},{immediate:57}],59:[function(b,g,c){c=b("./lib/utils/common").assign;var d=b("./lib/deflate"),e=b("./lib/inflate");b=b("./lib/zlib/constants");var a={};c(a,d,e,b);g.exports=a},{"./lib/deflate":60,"./lib/inflate":61,"./lib/utils/common":62,
"./lib/zlib/constants":65}],60:[function(b,g,c){function d(b){if(!(this instanceof d))return new d(b);b=this.options=h.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:""},b||{});b.raw&&0<b.windowBits?b.windowBits=-b.windowBits:b.gzip&&0<b.windowBits&&16>b.windowBits&&(b.windowBits+=16);this.err=0;this.msg="";this.ended=!1;this.chunks=[];this.strm=new q;this.strm.avail_out=0;var c=a.deflateInit2(this.strm,b.level,b.method,b.windowBits,b.memLevel,b.strategy);if(0!==
c)throw Error(f[c]);b.header&&a.deflateSetHeader(this.strm,b.header);if(b.dictionary){b="string"===typeof b.dictionary?k.string2buf(b.dictionary):"[object ArrayBuffer]"===A.call(b.dictionary)?new Uint8Array(b.dictionary):b.dictionary;c=a.deflateSetDictionary(this.strm,b);if(0!==c)throw Error(f[c]);this._dict_set=!0}}function e(a,b){var c=new d(b);c.push(a,!0);if(c.err)throw c.msg||f[c.err];return c.result}var a=b("./zlib/deflate"),h=b("./utils/common"),k=b("./utils/strings"),f=b("./zlib/messages"),
q=b("./zlib/zstream"),A=Object.prototype.toString;d.prototype.push=function(d,b){var c=this.strm,e=this.options.chunkSize,f,q;if(this.ended)return!1;q=b===~~b?b:!0===b?4:0;"string"===typeof d?c.input=k.string2buf(d):"[object ArrayBuffer]"===A.call(d)?c.input=new Uint8Array(d):c.input=d;c.next_in=0;c.avail_in=c.input.length;do{0===c.avail_out&&(c.output=new h.Buf8(e),c.next_out=0,c.avail_out=e);f=a.deflate(c,q);if(1!==f&&0!==f)return this.onEnd(f),this.ended=!0,!1;if(0===c.avail_out||0===c.avail_in&&
(4===q||2===q))if("string"===this.options.to)this.onData(k.buf2binstring(h.shrinkBuf(c.output,c.next_out)));else this.onData(h.shrinkBuf(c.output,c.next_out))}while((0<c.avail_in||0===c.avail_out)&&1!==f);if(4===q)return f=a.deflateEnd(this.strm),this.onEnd(f),this.ended=!0,0===f;2===q&&(this.onEnd(0),c.avail_out=0);return!0};d.prototype.onData=function(a){this.chunks.push(a)};d.prototype.onEnd=function(a){0===a&&(this.result="string"===this.options.to?this.chunks.join(""):h.flattenChunks(this.chunks));
this.chunks=[];this.err=a;this.msg=this.strm.msg};c.Deflate=d;c.deflate=e;c.deflateRaw=function(a,d){d=d||{};d.raw=!0;return e(a,d)};c.gzip=function(a,d){d=d||{};d.gzip=!0;return e(a,d)}},{"./utils/common":62,"./utils/strings":63,"./zlib/deflate":67,"./zlib/messages":72,"./zlib/zstream":74}],61:[function(b,g,c){function d(b){if(!(this instanceof d))return new d(b);var c=this.options=h.assign({chunkSize:16384,windowBits:0,to:""},b||{});c.raw&&0<=c.windowBits&&16>c.windowBits&&(c.windowBits=-c.windowBits,
0===c.windowBits&&(c.windowBits=-15));!(0<=c.windowBits&&16>c.windowBits)||b&&b.windowBits||(c.windowBits+=32);15<c.windowBits&&48>c.windowBits&&0===(c.windowBits&15)&&(c.windowBits|=15);this.err=0;this.msg="";this.ended=!1;this.chunks=[];this.strm=new A;this.strm.avail_out=0;b=a.inflateInit2(this.strm,c.windowBits);if(b!==f.Z_OK)throw Error(q[b]);this.header=new p;a.inflateGetHeader(this.strm,this.header)}function e(a,b){var c=new d(b);c.push(a,!0);if(c.err)throw c.msg||q[c.err];return c.result}
var a=b("./zlib/inflate"),h=b("./utils/common"),k=b("./utils/strings"),f=b("./zlib/constants"),q=b("./zlib/messages"),A=b("./zlib/zstream"),p=b("./zlib/gzheader"),y=Object.prototype.toString;d.prototype.push=function(d,b){var c=this.strm,e=this.options.chunkSize,q=this.options.dictionary,r,p,t,g,A,v=!1;if(this.ended)return!1;p=b===~~b?b:!0===b?f.Z_FINISH:f.Z_NO_FLUSH;"string"===typeof d?c.input=k.binstring2buf(d):"[object ArrayBuffer]"===y.call(d)?c.input=new Uint8Array(d):c.input=d;c.next_in=0;c.avail_in=
c.input.length;do{0===c.avail_out&&(c.output=new h.Buf8(e),c.next_out=0,c.avail_out=e);r=a.inflate(c,f.Z_NO_FLUSH);r===f.Z_NEED_DICT&&q&&(r="string"===typeof q?k.string2buf(q):"[object ArrayBuffer]"===y.call(q)?new Uint8Array(q):q,r=a.inflateSetDictionary(this.strm,r));r===f.Z_BUF_ERROR&&!0===v&&(r=f.Z_OK,v=!1);if(r!==f.Z_STREAM_END&&r!==f.Z_OK)return this.onEnd(r),this.ended=!0,!1;if(c.next_out&&(0===c.avail_out||r===f.Z_STREAM_END||0===c.avail_in&&(p===f.Z_FINISH||p===f.Z_SYNC_FLUSH)))if("string"===
this.options.to)t=k.utf8border(c.output,c.next_out),g=c.next_out-t,A=k.buf2string(c.output,t),c.next_out=g,c.avail_out=e-g,g&&h.arraySet(c.output,c.output,t,g,0),this.onData(A);else this.onData(h.shrinkBuf(c.output,c.next_out));0===c.avail_in&&0===c.avail_out&&(v=!0)}while((0<c.avail_in||0===c.avail_out)&&r!==f.Z_STREAM_END);r===f.Z_STREAM_END&&(p=f.Z_FINISH);if(p===f.Z_FINISH)return r=a.inflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===f.Z_OK;p===f.Z_SYNC_FLUSH&&(this.onEnd(f.Z_OK),c.avail_out=
0);return!0};d.prototype.onData=function(a){this.chunks.push(a)};d.prototype.onEnd=function(a){a===f.Z_OK&&(this.result="string"===this.options.to?this.chunks.join(""):h.flattenChunks(this.chunks));this.chunks=[];this.err=a;this.msg=this.strm.msg};c.Inflate=d;c.inflate=e;c.inflateRaw=function(a,d){d=d||{};d.raw=!0;return e(a,d)};c.ungzip=e},{"./utils/common":62,"./utils/strings":63,"./zlib/constants":65,"./zlib/gzheader":68,"./zlib/inflate":70,"./zlib/messages":72,"./zlib/zstream":74}],62:[function(b,
g,c){b="undefined"!==typeof Uint8Array&&"undefined"!==typeof Uint16Array&&"undefined"!==typeof Int32Array;c.assign=function(a){for(var d=Array.prototype.slice.call(arguments,1);d.length;){var b=d.shift();if(b){if("object"!==typeof b)throw new TypeError(b+"must be non-object");for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])}}return a};c.shrinkBuf=function(a,d){if(a.length===d)return a;if(a.subarray)return a.subarray(0,d);a.length=d;return a};var d={arraySet:function(a,d,b,c,e){if(d.subarray&&a.subarray)a.set(d.subarray(b,
b+c),e);else for(var g=0;g<c;g++)a[e+g]=d[b+g]},flattenChunks:function(a){var d,b,c,e,g;d=c=0;for(b=a.length;d<b;d++)c+=a[d].length;g=new Uint8Array(c);d=c=0;for(b=a.length;d<b;d++)e=a[d],g.set(e,c),c+=e.length;return g}},e={arraySet:function(a,d,b,c,e){for(var g=0;g<c;g++)a[e+g]=d[b+g]},flattenChunks:function(a){return[].concat.apply([],a)}};c.setTyped=function(a){a?(c.Buf8=Uint8Array,c.Buf16=Uint16Array,c.Buf32=Int32Array,c.assign(c,d)):(c.Buf8=Array,c.Buf16=Array,c.Buf32=Array,c.assign(c,e))};
c.setTyped(b)},{}],63:[function(b,g,c){function d(d,b){if(65537>b&&(d.subarray&&h||!d.subarray&&a))return String.fromCharCode.apply(null,e.shrinkBuf(d,b));for(var c="",k=0;k<b;k++)c+=String.fromCharCode(d[k]);return c}var e=b("./common"),a=!0,h=!0;try{String.fromCharCode.apply(null,[0])}catch(f){a=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(f){h=!1}var k=new e.Buf8(256);for(b=0;256>b;b++)k[b]=252<=b?6:248<=b?5:240<=b?4:224<=b?3:192<=b?2:1;k[254]=k[254]=1;c.string2buf=function(a){var d,
b,c,k,h,g=a.length,C=0;for(k=0;k<g;k++)b=a.charCodeAt(k),55296===(b&64512)&&k+1<g&&(c=a.charCodeAt(k+1),56320===(c&64512)&&(b=65536+(b-55296<<10)+(c-56320),k++)),C+=128>b?1:2048>b?2:65536>b?3:4;d=new e.Buf8(C);for(k=h=0;h<C;k++)b=a.charCodeAt(k),55296===(b&64512)&&k+1<g&&(c=a.charCodeAt(k+1),56320===(c&64512)&&(b=65536+(b-55296<<10)+(c-56320),k++)),128>b?d[h++]=b:(2048>b?d[h++]=192|b>>>6:(65536>b?d[h++]=224|b>>>12:(d[h++]=240|b>>>18,d[h++]=128|b>>>12&63),d[h++]=128|b>>>6&63),d[h++]=128|b&63);return d};
c.buf2binstring=function(a){return d(a,a.length)};c.binstring2buf=function(a){for(var d=new e.Buf8(a.length),b=0,c=d.length;b<c;b++)d[b]=a.charCodeAt(b);return d};c.buf2string=function(a,b){var c,e,h,g,F=b||a.length,C=Array(2*F);for(c=e=0;c<F;)if(h=a[c++],128>h)C[e++]=h;else if(g=k[h],4<g)C[e++]=65533,c+=g-1;else{for(h&=2===g?31:3===g?15:7;1<g&&c<F;)h=h<<6|a[c++]&63,g--;1<g?C[e++]=65533:65536>h?C[e++]=h:(h-=65536,C[e++]=55296|h>>10&1023,C[e++]=56320|h&1023)}return d(C,e)};c.utf8border=function(a,
d){var b;d=d||a.length;d>a.length&&(d=a.length);for(b=d-1;0<=b&&128===(a[b]&192);)b--;return 0>b||0===b?d:b+k[a[b]]>d?b:d}},{"./common":62}],64:[function(b,g,c){g.exports=function(d,b,a,c){var k=d&65535|0;d=d>>>16&65535|0;for(var f=0;0!==a;){f=2E3<a?2E3:a;a-=f;do k=k+b[c++]|0,d=d+k|0;while(--f);k%=65521;d%=65521}return k|d<<16|0}},{}],65:[function(b,g,c){g.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,
Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],66:[function(b,g,c){var d=function(){for(var b,a=[],d=0;256>d;d++){b=d;for(var c=0;8>c;c++)b=b&1?3988292384^b>>>1:b>>>1;a[d]=b}return a}();g.exports=function(b,a,c,k){c=k+c;for(b^=-1;k<c;k++)b=b>>>8^d[(b^a[k])&255];return b^-1}},{}],67:[function(b,g,c){function d(a,
b){a.msg=E[b];return b}function e(a){for(var b=a.length;0<=--b;)a[b]=0}function a(a){var b=a.state,d=b.pending;d>a.avail_out&&(d=a.avail_out);0!==d&&(t.arraySet(a.output,b.pending_buf,b.pending_out,d,a.next_out),a.next_out+=d,b.pending_out+=d,a.total_out+=d,a.avail_out-=d,b.pending-=d,0===b.pending&&(b.pending_out=0))}function h(b,d){L._tr_flush_block(b,0<=b.block_start?b.block_start:-1,b.strstart-b.block_start,d);b.block_start=b.strstart;a(b.strm)}function k(a,b){a.pending_buf[a.pending++]=b}function f(a,
b){a.pending_buf[a.pending++]=b>>>8&255;a.pending_buf[a.pending++]=b&255}function q(a,b){var d=a.max_chain_length,c=a.strstart,t,e=a.prev_length,r=a.nice_match,k=a.strstart>a.w_size-262?a.strstart-(a.w_size-262):0,f=a.window,h=a.w_mask,P=a.prev,g=a.strstart+258,q=f[c+e-1],p=f[c+e];a.prev_length>=a.good_match&&(d>>=2);r>a.lookahead&&(r=a.lookahead);do if(t=b,f[t+e]===p&&f[t+e-1]===q&&f[t]===f[c]&&f[++t]===f[c+1]){c+=2;for(t++;f[++c]===f[++t]&&f[++c]===f[++t]&&f[++c]===f[++t]&&f[++c]===f[++t]&&f[++c]===
f[++t]&&f[++c]===f[++t]&&f[++c]===f[++t]&&f[++c]===f[++t]&&c<g;);t=258-(g-c);c=g-258;if(t>e){a.match_start=b;e=t;if(t>=r)break;q=f[c+e-1];p=f[c+e]}}while((b=P[b&h])>k&&0!==--d);return e<=a.lookahead?e:a.lookahead}function A(a){var b=a.w_size,d,c,e,r;do{r=a.window_size-a.lookahead-a.strstart;if(a.strstart>=b+(b-262)){t.arraySet(a.window,a.window,b,b,0);a.match_start-=b;a.strstart-=b;a.block_start-=b;d=c=a.hash_size;do e=a.head[--d],a.head[d]=e>=b?e-b:0;while(--c);d=c=b;do e=a.prev[--d],a.prev[d]=e>=
b?e-b:0;while(--c);r+=b}if(0===a.strm.avail_in)break;d=a.strm;c=a.window;e=a.strstart+a.lookahead;var f=d.avail_in;f>r&&(f=r);0===f?c=0:(d.avail_in-=f,t.arraySet(c,d.input,d.next_in,f,e),1===d.state.wrap?d.adler=B(d.adler,c,f,e):2===d.state.wrap&&(d.adler=v(d.adler,c,f,e)),d.next_in+=f,d.total_in+=f,c=f);a.lookahead+=c;if(3<=a.lookahead+a.insert)for(r=a.strstart-a.insert,a.ins_h=a.window[r],a.ins_h=(a.ins_h<<a.hash_shift^a.window[r+1])&a.hash_mask;a.insert&&!(a.ins_h=(a.ins_h<<a.hash_shift^a.window[r+
3-1])&a.hash_mask,a.prev[r&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=r,r++,a.insert--,3>a.lookahead+a.insert););}while(262>a.lookahead&&0!==a.strm.avail_in)}function p(a,b){for(var d;;){if(262>a.lookahead){A(a);if(262>a.lookahead&&0===b)return 1;if(0===a.lookahead)break}d=0;3<=a.lookahead&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,d=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart);0!==d&&a.strstart-d<=a.w_size-262&&(a.match_length=q(a,d));if(3<=a.match_length)if(d=
L._tr_tally(a,a.strstart-a.match_start,a.match_length-3),a.lookahead-=a.match_length,a.match_length<=a.max_lazy_match&&3<=a.lookahead){a.match_length--;do a.strstart++,a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart;while(0!==--a.match_length);a.strstart++}else a.strstart+=a.match_length,a.match_length=0,a.ins_h=a.window[a.strstart],a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+1])&a.hash_mask;else d=
L._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++;if(d&&(h(a,!1),0===a.strm.avail_out))return 1}a.insert=2>a.strstart?a.strstart:2;return 4===b?(h(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?1:2}function y(a,b){for(var d,c;;){if(262>a.lookahead){A(a);if(262>a.lookahead&&0===b)return 1;if(0===a.lookahead)break}d=0;3<=a.lookahead&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,d=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=
a.strstart);a.prev_length=a.match_length;a.prev_match=a.match_start;a.match_length=2;0!==d&&a.prev_length<a.max_lazy_match&&a.strstart-d<=a.w_size-262&&(a.match_length=q(a,d),5>=a.match_length&&(1===a.strategy||3===a.match_length&&4096<a.strstart-a.match_start)&&(a.match_length=2));if(3<=a.prev_length&&a.match_length<=a.prev_length){c=a.strstart+a.lookahead-3;d=L._tr_tally(a,a.strstart-1-a.prev_match,a.prev_length-3);a.lookahead-=a.prev_length-1;a.prev_length-=2;do++a.strstart<=c&&(a.ins_h=(a.ins_h<<
a.hash_shift^a.window[a.strstart+3-1])&a.hash_mask,a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart);while(0!==--a.prev_length);a.match_available=0;a.match_length=2;a.strstart++;if(d&&(h(a,!1),0===a.strm.avail_out))return 1}else if(a.match_available){if((d=L._tr_tally(a,0,a.window[a.strstart-1]))&&h(a,!1),a.strstart++,a.lookahead--,0===a.strm.avail_out)return 1}else a.match_available=1,a.strstart++,a.lookahead--}a.match_available&&(L._tr_tally(a,0,a.window[a.strstart-1]),a.match_available=
0);a.insert=2>a.strstart?a.strstart:2;return 4===b?(h(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?1:2}function G(a,b){for(var d,c,t,e=a.window;;){if(258>=a.lookahead){A(a);if(258>=a.lookahead&&0===b)return 1;if(0===a.lookahead)break}a.match_length=0;if(3<=a.lookahead&&0<a.strstart&&(c=a.strstart-1,d=e[c],d===e[++c]&&d===e[++c]&&d===e[++c])){for(t=a.strstart+258;d===e[++c]&&d===e[++c]&&d===e[++c]&&d===e[++c]&&d===e[++c]&&d===e[++c]&&d===e[++c]&&d===e[++c]&&c<t;);a.match_length=
258-(t-c);a.match_length>a.lookahead&&(a.match_length=a.lookahead)}3<=a.match_length?(d=L._tr_tally(a,1,a.match_length-3),a.lookahead-=a.match_length,a.strstart+=a.match_length,a.match_length=0):(d=L._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++);if(d&&(h(a,!1),0===a.strm.avail_out))return 1}a.insert=0;return 4===b?(h(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?1:2}function F(a,d){for(var b;;){if(0===a.lookahead&&(A(a),0===a.lookahead)){if(0===d)return 1;
break}a.match_length=0;b=L._tr_tally(a,0,a.window[a.strstart]);a.lookahead--;a.strstart++;if(b&&(h(a,!1),0===a.strm.avail_out))return 1}a.insert=0;return 4===d?(h(a,!0),0===a.strm.avail_out?3:4):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?1:2}function C(a,d,b,c,t){this.good_length=a;this.max_lazy=d;this.nice_length=b;this.max_chain=c;this.func=t}function w(){this.strm=null;this.status=0;this.pending_buf=null;this.wrap=this.pending=this.pending_out=this.pending_buf_size=0;this.gzhead=null;this.gzindex=
0;this.method=8;this.last_flush=-1;this.w_mask=this.w_bits=this.w_size=0;this.window=null;this.window_size=0;this.head=this.prev=null;this.nice_match=this.good_match=this.strategy=this.level=this.max_lazy_match=this.max_chain_length=this.prev_length=this.lookahead=this.match_start=this.strstart=this.match_available=this.prev_match=this.match_length=this.block_start=this.hash_shift=this.hash_mask=this.hash_bits=this.hash_size=this.ins_h=0;this.dyn_ltree=new t.Buf16(1146);this.dyn_dtree=new t.Buf16(122);
this.bl_tree=new t.Buf16(78);e(this.dyn_ltree);e(this.dyn_dtree);e(this.bl_tree);this.bl_desc=this.d_desc=this.l_desc=null;this.bl_count=new t.Buf16(16);this.heap=new t.Buf16(573);e(this.heap);this.heap_max=this.heap_len=0;this.depth=new t.Buf16(573);e(this.depth);this.bi_valid=this.bi_buf=this.insert=this.matches=this.static_len=this.opt_len=this.d_buf=this.last_lit=this.lit_bufsize=this.l_buf=0}function x(a){var b;if(!a||!a.state)return d(a,-2);a.total_in=a.total_out=0;a.data_type=2;b=a.state;b.pending=
0;b.pending_out=0;0>b.wrap&&(b.wrap=-b.wrap);b.status=b.wrap?42:113;a.adler=2===b.wrap?0:1;b.last_flush=0;L._tr_init(b);return 0}function r(a){var b=x(a);0===b&&(a=a.state,a.window_size=2*a.w_size,e(a.head),a.max_lazy_match=H[a.level].max_lazy,a.good_match=H[a.level].good_length,a.nice_match=H[a.level].nice_length,a.max_chain_length=H[a.level].max_chain,a.strstart=0,a.block_start=0,a.lookahead=0,a.insert=0,a.match_length=a.prev_length=2,a.match_available=0,a.ins_h=0);return b}function K(a,b,c,e,f,
k){if(!a)return-2;var h=1;-1===b&&(b=6);0>e?(h=0,e=-e):15<e&&(h=2,e-=16);if(1>f||9<f||8!==c||8>e||15<e||0>b||9<b||0>k||4<k)return d(a,-2);8===e&&(e=9);var g=new w;a.state=g;g.strm=a;g.wrap=h;g.gzhead=null;g.w_bits=e;g.w_size=1<<g.w_bits;g.w_mask=g.w_size-1;g.hash_bits=f+7;g.hash_size=1<<g.hash_bits;g.hash_mask=g.hash_size-1;g.hash_shift=~~((g.hash_bits+3-1)/3);g.window=new t.Buf8(2*g.w_size);g.head=new t.Buf16(g.hash_size);g.prev=new t.Buf16(g.w_size);g.lit_bufsize=1<<f+6;g.pending_buf_size=4*g.lit_bufsize;
g.pending_buf=new t.Buf8(g.pending_buf_size);g.d_buf=1*g.lit_bufsize;g.l_buf=3*g.lit_bufsize;g.level=b;g.strategy=k;g.method=c;return r(a)}var t=b("../utils/common"),L=b("./trees"),B=b("./adler32"),v=b("./crc32"),E=b("./messages"),H;H=[new C(0,0,0,0,function(a,b){var d=65535;for(d>a.pending_buf_size-5&&(d=a.pending_buf_size-5);;){if(1>=a.lookahead){A(a);if(0===a.lookahead&&0===b)return 1;if(0===a.lookahead)break}a.strstart+=a.lookahead;a.lookahead=0;var c=a.block_start+d;if(0===a.strstart||a.strstart>=
c)if(a.lookahead=a.strstart-c,a.strstart=c,h(a,!1),0===a.strm.avail_out)return 1;if(a.strstart-a.block_start>=a.w_size-262&&(h(a,!1),0===a.strm.avail_out))return 1}a.insert=0;if(4===b)return h(a,!0),0===a.strm.avail_out?3:4;a.strstart>a.block_start&&h(a,!1);return 1}),new C(4,4,8,4,p),new C(4,5,16,8,p),new C(4,6,32,32,p),new C(4,4,16,16,y),new C(8,16,32,32,y),new C(8,16,128,128,y),new C(8,32,128,256,y),new C(32,128,258,1024,y),new C(32,258,258,4096,y)];c.deflateInit=function(a,b){return K(a,b,8,15,
8,0)};c.deflateInit2=K;c.deflateReset=r;c.deflateResetKeep=x;c.deflateSetHeader=function(a,b){if(!a||!a.state||2!==a.state.wrap)return-2;a.state.gzhead=b;return 0};c.deflate=function(b,c){var t,l,r,g;if(!b||!b.state||5<c||0>c)return b?d(b,-2):-2;l=b.state;if(!b.output||!b.input&&0!==b.avail_in||666===l.status&&4!==c)return d(b,0===b.avail_out?-5:-2);l.strm=b;t=l.last_flush;l.last_flush=c;42===l.status&&(2===l.wrap?(b.adler=0,k(l,31),k(l,139),k(l,8),l.gzhead?(k(l,(l.gzhead.text?1:0)+(l.gzhead.hcrc?
2:0)+(l.gzhead.extra?4:0)+(l.gzhead.name?8:0)+(l.gzhead.comment?16:0)),k(l,l.gzhead.time&255),k(l,l.gzhead.time>>8&255),k(l,l.gzhead.time>>16&255),k(l,l.gzhead.time>>24&255),k(l,9===l.level?2:2<=l.strategy||2>l.level?4:0),k(l,l.gzhead.os&255),l.gzhead.extra&&l.gzhead.extra.length&&(k(l,l.gzhead.extra.length&255),k(l,l.gzhead.extra.length>>8&255)),l.gzhead.hcrc&&(b.adler=v(b.adler,l.pending_buf,l.pending,0)),l.gzindex=0,l.status=69):(k(l,0),k(l,0),k(l,0),k(l,0),k(l,0),k(l,9===l.level?2:2<=l.strategy||
2>l.level?4:0),k(l,3),l.status=113)):(r=8+(l.w_bits-8<<4)<<8,g=-1,g=2<=l.strategy||2>l.level?0:6>l.level?1:6===l.level?2:3,r|=g<<6,0!==l.strstart&&(r|=32),l.status=113,f(l,r+(31-r%31)),0!==l.strstart&&(f(l,b.adler>>>16),f(l,b.adler&65535)),b.adler=1));if(69===l.status)if(l.gzhead.extra){for(r=l.pending;l.gzindex<(l.gzhead.extra.length&65535)&&(l.pending!==l.pending_buf_size||(l.gzhead.hcrc&&l.pending>r&&(b.adler=v(b.adler,l.pending_buf,l.pending-r,r)),a(b),r=l.pending,l.pending!==l.pending_buf_size));)k(l,
l.gzhead.extra[l.gzindex]&255),l.gzindex++;l.gzhead.hcrc&&l.pending>r&&(b.adler=v(b.adler,l.pending_buf,l.pending-r,r));l.gzindex===l.gzhead.extra.length&&(l.gzindex=0,l.status=73)}else l.status=73;if(73===l.status)if(l.gzhead.name){r=l.pending;do{if(l.pending===l.pending_buf_size&&(l.gzhead.hcrc&&l.pending>r&&(b.adler=v(b.adler,l.pending_buf,l.pending-r,r)),a(b),r=l.pending,l.pending===l.pending_buf_size)){g=1;break}g=l.gzindex<l.gzhead.name.length?l.gzhead.name.charCodeAt(l.gzindex++)&255:0;k(l,
g)}while(0!==g);l.gzhead.hcrc&&l.pending>r&&(b.adler=v(b.adler,l.pending_buf,l.pending-r,r));0===g&&(l.gzindex=0,l.status=91)}else l.status=91;if(91===l.status)if(l.gzhead.comment){r=l.pending;do{if(l.pending===l.pending_buf_size&&(l.gzhead.hcrc&&l.pending>r&&(b.adler=v(b.adler,l.pending_buf,l.pending-r,r)),a(b),r=l.pending,l.pending===l.pending_buf_size)){g=1;break}g=l.gzindex<l.gzhead.comment.length?l.gzhead.comment.charCodeAt(l.gzindex++)&255:0;k(l,g)}while(0!==g);l.gzhead.hcrc&&l.pending>r&&(b.adler=
v(b.adler,l.pending_buf,l.pending-r,r));0===g&&(l.status=103)}else l.status=103;103===l.status&&(l.gzhead.hcrc?(l.pending+2>l.pending_buf_size&&a(b),l.pending+2<=l.pending_buf_size&&(k(l,b.adler&255),k(l,b.adler>>8&255),b.adler=0,l.status=113)):l.status=113);if(0!==l.pending){if(a(b),0===b.avail_out)return l.last_flush=-1,0}else if(0===b.avail_in&&(c<<1)-(4<c?9:0)<=(t<<1)-(4<t?9:0)&&4!==c)return d(b,-5);if(666===l.status&&0!==b.avail_in)return d(b,-5);if(0!==b.avail_in||0!==l.lookahead||0!==c&&666!==
l.status){t=2===l.strategy?F(l,c):3===l.strategy?G(l,c):H[l.level].func(l,c);if(3===t||4===t)l.status=666;if(1===t||3===t)return 0===b.avail_out&&(l.last_flush=-1),0;if(2===t&&(1===c?L._tr_align(l):5!==c&&(L._tr_stored_block(l,0,0,!1),3===c&&(e(l.head),0===l.lookahead&&(l.strstart=0,l.block_start=0,l.insert=0))),a(b),0===b.avail_out))return l.last_flush=-1,0}if(4!==c)return 0;if(0>=l.wrap)return 1;2===l.wrap?(k(l,b.adler&255),k(l,b.adler>>8&255),k(l,b.adler>>16&255),k(l,b.adler>>24&255),k(l,b.total_in&
255),k(l,b.total_in>>8&255),k(l,b.total_in>>16&255),k(l,b.total_in>>24&255)):(f(l,b.adler>>>16),f(l,b.adler&65535));a(b);0<l.wrap&&(l.wrap=-l.wrap);return 0!==l.pending?0:1};c.deflateEnd=function(a){var b;if(!a||!a.state)return-2;b=a.state.status;if(42!==b&&69!==b&&73!==b&&91!==b&&103!==b&&113!==b&&666!==b)return d(a,-2);a.state=null;return 113===b?d(a,-3):0};c.deflateSetDictionary=function(a,b){var d=b.length,c,r,f,g,k,h;if(!a||!a.state)return-2;c=a.state;f=c.wrap;if(2===f||1===f&&42!==c.status||
c.lookahead)return-2;1===f&&(a.adler=B(a.adler,b,d,0));c.wrap=0;d>=c.w_size&&(0===f&&(e(c.head),c.strstart=0,c.block_start=0,c.insert=0),g=new t.Buf8(c.w_size),t.arraySet(g,b,d-c.w_size,c.w_size,0),b=g,d=c.w_size);g=a.avail_in;k=a.next_in;h=a.input;a.avail_in=d;a.next_in=0;a.input=b;for(A(c);3<=c.lookahead;){d=c.strstart;r=c.lookahead-2;do c.ins_h=(c.ins_h<<c.hash_shift^c.window[d+3-1])&c.hash_mask,c.prev[d&c.w_mask]=c.head[c.ins_h],c.head[c.ins_h]=d,d++;while(--r);c.strstart=d;c.lookahead=2;A(c)}c.strstart+=
c.lookahead;c.block_start=c.strstart;c.insert=c.lookahead;c.lookahead=0;c.match_length=c.prev_length=2;c.match_available=0;a.next_in=k;a.input=h;a.avail_in=g;c.wrap=f;return 0};c.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":62,"./adler32":64,"./crc32":66,"./messages":72,"./trees":73}],68:[function(b,g,c){g.exports=function(){this.os=this.xflags=this.time=this.text=0;this.extra=null;this.extra_len=0;this.comment=this.name="";this.hcrc=0;this.done=!1}},{}],69:[function(b,g,c){g.exports=
function(b,c){var a,g,k,f,q,A,p,y,G,F,C,w,x,r,K,t,L,B,v,E,H,D,m,n;a=b.state;g=b.next_in;m=b.input;k=g+(b.avail_in-5);f=b.next_out;n=b.output;q=f-(c-b.avail_out);A=f+(b.avail_out-257);p=a.dmax;y=a.wsize;G=a.whave;F=a.wnext;C=a.window;w=a.hold;x=a.bits;r=a.lencode;K=a.distcode;t=(1<<a.lenbits)-1;L=(1<<a.distbits)-1;a:do b:for(15>x&&(w+=m[g++]<<x,x+=8,w+=m[g++]<<x,x+=8),B=r[w&t];;){v=B>>>24;w>>>=v;x-=v;v=B>>>16&255;if(0===v)n[f++]=B&65535;else if(v&16){E=B&65535;if(v&=15)x<v&&(w+=m[g++]<<x,x+=8),E+=
w&(1<<v)-1,w>>>=v,x-=v;15>x&&(w+=m[g++]<<x,x+=8,w+=m[g++]<<x,x+=8);B=K[w&L];c:for(;;){v=B>>>24;w>>>=v;x-=v;v=B>>>16&255;if(v&16){B&=65535;v&=15;x<v&&(w+=m[g++]<<x,x+=8,x<v&&(w+=m[g++]<<x,x+=8));B+=w&(1<<v)-1;if(B>p){b.msg="invalid distance too far back";a.mode=30;break a}w>>>=v;x-=v;v=f-q;if(B>v){v=B-v;if(v>G&&a.sane){b.msg="invalid distance too far back";a.mode=30;break a}H=0;D=C;if(0===F){if(H+=y-v,v<E){E-=v;do n[f++]=C[H++];while(--v);H=f-B;D=n}}else if(F<v){if(H+=y+F-v,v-=F,v<E){E-=v;do n[f++]=
C[H++];while(--v);H=0;if(F<E){v=F;E-=v;do n[f++]=C[H++];while(--v);H=f-B;D=n}}}else if(H+=F-v,v<E){E-=v;do n[f++]=C[H++];while(--v);H=f-B;D=n}for(;2<E;)n[f++]=D[H++],n[f++]=D[H++],n[f++]=D[H++],E-=3;E&&(n[f++]=D[H++],1<E&&(n[f++]=D[H++]))}else{H=f-B;do n[f++]=n[H++],n[f++]=n[H++],n[f++]=n[H++],E-=3;while(2<E);E&&(n[f++]=n[H++],1<E&&(n[f++]=n[H++]))}}else if(0===(v&64)){B=K[(B&65535)+(w&(1<<v)-1)];continue c}else{b.msg="invalid distance code";a.mode=30;break a}break}}else if(0===(v&64)){B=r[(B&65535)+
(w&(1<<v)-1)];continue b}else{v&32?a.mode=12:(b.msg="invalid literal/length code",a.mode=30);break a}break}while(g<k&&f<A);E=x>>3;g-=E;x-=E<<3;b.next_in=g;b.next_out=f;b.avail_in=g<k?5+(k-g):5-(g-k);b.avail_out=f<A?257+(A-f):257-(f-A);a.hold=w&(1<<x)-1;a.bits=x}},{}],70:[function(b,g,c){function d(a){return(a>>>24&255)+(a>>>8&65280)+((a&65280)<<8)+((a&255)<<24)}function e(){this.mode=0;this.last=!1;this.wrap=0;this.havedict=!1;this.total=this.check=this.dmax=this.flags=0;this.head=null;this.wnext=
this.whave=this.wsize=this.wbits=0;this.window=null;this.extra=this.offset=this.length=this.bits=this.hold=0;this.distcode=this.lencode=null;this.have=this.ndist=this.nlen=this.ncode=this.distbits=this.lenbits=0;this.next=null;this.lens=new A.Buf16(320);this.work=new A.Buf16(288);this.distdyn=this.lendyn=null;this.was=this.back=this.sane=0}function a(a){var b;if(!a||!a.state)return-2;b=a.state;a.total_in=a.total_out=b.total=0;a.msg="";b.wrap&&(a.adler=b.wrap&1);b.mode=1;b.last=0;b.havedict=0;b.dmax=
32768;b.head=null;b.hold=0;b.bits=0;b.lencode=b.lendyn=new A.Buf32(852);b.distcode=b.distdyn=new A.Buf32(592);b.sane=1;b.back=-1;return 0}function h(b){var d;if(!b||!b.state)return-2;d=b.state;d.wsize=0;d.whave=0;d.wnext=0;return a(b)}function k(a,b){var d,c;if(!a||!a.state)return-2;c=a.state;0>b?(d=0,b=-b):(d=(b>>4)+1,48>b&&(b&=15));if(b&&(8>b||15<b))return-2;null!==c.window&&c.wbits!==b&&(c.window=null);c.wrap=d;c.wbits=b;return h(a)}function f(a,b){var d;if(!a)return-2;d=new e;a.state=d;d.window=
null;d=k(a,b);0!==d&&(a.state=null);return d}function q(a,b,d,c){var e=a.state;null===e.window&&(e.wsize=1<<e.wbits,e.wnext=0,e.whave=0,e.window=new A.Buf8(e.wsize));c>=e.wsize?(A.arraySet(e.window,b,d-e.wsize,e.wsize,0),e.wnext=0,e.whave=e.wsize):(a=e.wsize-e.wnext,a>c&&(a=c),A.arraySet(e.window,b,d-c,a,e.wnext),(c-=a)?(A.arraySet(e.window,b,d-c,c,0),e.wnext=c,e.whave=e.wsize):(e.wnext+=a,e.wnext===e.wsize&&(e.wnext=0),e.whave<e.wsize&&(e.whave+=a)));return 0}var A=b("../utils/common"),p=b("./adler32"),
y=b("./crc32"),G=b("./inffast"),F=b("./inftrees"),C=!0,w,x;c.inflateReset=h;c.inflateReset2=k;c.inflateResetKeep=a;c.inflateInit=function(a){return f(a,15)};c.inflateInit2=f;c.inflate=function(a,b){var c,e,g,f,k,h,D,m,n,l,J,u,z,M,I=0,Q,P,N,O=new A.Buf8(4),S=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!a||!a.state||!a.output||!a.input&&0!==a.avail_in)return-2;c=a.state;12===c.mode&&(c.mode=13);k=a.next_out;g=a.output;D=a.avail_out;f=a.next_in;e=a.input;h=a.avail_in;m=c.hold;n=c.bits;l=h;J=
D;N=0;a:for(;;)switch(c.mode){case 1:if(0===c.wrap){c.mode=13;break}for(;16>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}if(c.wrap&2&&35615===m){c.check=0;O[0]=m&255;O[1]=m>>>8&255;c.check=y(c.check,O,2,0);n=m=0;c.mode=2;break}c.flags=0;c.head&&(c.head.done=!1);if(!(c.wrap&1)||(((m&255)<<8)+(m>>8))%31){a.msg="incorrect header check";c.mode=30;break}if(8!==(m&15)){a.msg="unknown compression method";c.mode=30;break}m>>>=4;n-=4;z=(m&15)+8;if(0===c.wbits)c.wbits=z;else if(z>c.wbits){a.msg="invalid window size";
c.mode=30;break}c.dmax=1<<z;a.adler=c.check=1;c.mode=m&512?10:12;n=m=0;break;case 2:for(;16>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.flags=m;if(8!==(c.flags&255)){a.msg="unknown compression method";c.mode=30;break}if(c.flags&57344){a.msg="unknown header flags set";c.mode=30;break}c.head&&(c.head.text=m>>8&1);c.flags&512&&(O[0]=m&255,O[1]=m>>>8&255,c.check=y(c.check,O,2,0));n=m=0;c.mode=3;case 3:for(;32>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.head&&(c.head.time=m);c.flags&512&&(O[0]=m&255,
O[1]=m>>>8&255,O[2]=m>>>16&255,O[3]=m>>>24&255,c.check=y(c.check,O,4,0));n=m=0;c.mode=4;case 4:for(;16>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.head&&(c.head.xflags=m&255,c.head.os=m>>8);c.flags&512&&(O[0]=m&255,O[1]=m>>>8&255,c.check=y(c.check,O,2,0));n=m=0;c.mode=5;case 5:if(c.flags&1024){for(;16>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.length=m;c.head&&(c.head.extra_len=m);c.flags&512&&(O[0]=m&255,O[1]=m>>>8&255,c.check=y(c.check,O,2,0));n=m=0}else c.head&&(c.head.extra=null);c.mode=6;
case 6:if(c.flags&1024&&(u=c.length,u>h&&(u=h),u&&(c.head&&(z=c.head.extra_len-c.length,c.head.extra||(c.head.extra=Array(c.head.extra_len)),A.arraySet(c.head.extra,e,f,u,z)),c.flags&512&&(c.check=y(c.check,e,u,f)),h-=u,f+=u,c.length-=u),c.length))break a;c.length=0;c.mode=7;case 7:if(c.flags&2048){if(0===h)break a;u=0;do z=e[f+u++],c.head&&z&&65536>c.length&&(c.head.name+=String.fromCharCode(z));while(z&&u<h);c.flags&512&&(c.check=y(c.check,e,u,f));h-=u;f+=u;if(z)break a}else c.head&&(c.head.name=
null);c.length=0;c.mode=8;case 8:if(c.flags&4096){if(0===h)break a;u=0;do z=e[f+u++],c.head&&z&&65536>c.length&&(c.head.comment+=String.fromCharCode(z));while(z&&u<h);c.flags&512&&(c.check=y(c.check,e,u,f));h-=u;f+=u;if(z)break a}else c.head&&(c.head.comment=null);c.mode=9;case 9:if(c.flags&512){for(;16>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}if(m!==(c.check&65535)){a.msg="header crc mismatch";c.mode=30;break}n=m=0}c.head&&(c.head.hcrc=c.flags>>9&1,c.head.done=!0);a.adler=c.check=0;c.mode=12;break;
case 10:for(;32>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}a.adler=c.check=d(m);n=m=0;c.mode=11;case 11:if(0===c.havedict)return a.next_out=k,a.avail_out=D,a.next_in=f,a.avail_in=h,c.hold=m,c.bits=n,2;a.adler=c.check=1;c.mode=12;case 12:if(5===b||6===b)break a;case 13:if(c.last){m>>>=n&7;n-=n&7;c.mode=27;break}for(;3>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.last=m&1;m>>>=1;--n;switch(m&3){case 0:c.mode=14;break;case 1:u=c;if(C){z=void 0;w=new A.Buf32(512);x=new A.Buf32(32);for(z=0;144>z;)u.lens[z++]=
8;for(;256>z;)u.lens[z++]=9;for(;280>z;)u.lens[z++]=7;for(;288>z;)u.lens[z++]=8;F(1,u.lens,0,288,w,0,u.work,{bits:9});for(z=0;32>z;)u.lens[z++]=5;F(2,u.lens,0,32,x,0,u.work,{bits:5});C=!1}u.lencode=w;u.lenbits=9;u.distcode=x;u.distbits=5;c.mode=20;if(6===b){m>>>=2;n-=2;break a}break;case 2:c.mode=17;break;case 3:a.msg="invalid block type",c.mode=30}m>>>=2;n-=2;break;case 14:m>>>=n&7;for(n-=n&7;32>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}if((m&65535)!==(m>>>16^65535)){a.msg="invalid stored block lengths";
c.mode=30;break}c.length=m&65535;n=m=0;c.mode=15;if(6===b)break a;case 15:c.mode=16;case 16:if(u=c.length){u>h&&(u=h);u>D&&(u=D);if(0===u)break a;A.arraySet(g,e,f,u,k);h-=u;f+=u;D-=u;k+=u;c.length-=u;break}c.mode=12;break;case 17:for(;14>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.nlen=(m&31)+257;m>>>=5;n-=5;c.ndist=(m&31)+1;m>>>=5;n-=5;c.ncode=(m&15)+4;m>>>=4;n-=4;if(286<c.nlen||30<c.ndist){a.msg="too many length or distance symbols";c.mode=30;break}c.have=0;c.mode=18;case 18:for(;c.have<c.ncode;){for(;3>
n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.lens[S[c.have++]]=m&7;m>>>=3;n-=3}for(;19>c.have;)c.lens[S[c.have++]]=0;c.lencode=c.lendyn;c.lenbits=7;u={bits:c.lenbits};N=F(0,c.lens,0,19,c.lencode,0,c.work,u);c.lenbits=u.bits;if(N){a.msg="invalid code lengths set";c.mode=30;break}c.have=0;c.mode=19;case 19:for(;c.have<c.nlen+c.ndist;){for(;;){I=c.lencode[m&(1<<c.lenbits)-1];u=I>>>24;I&=65535;if(u<=n)break;if(0===h)break a;h--;m+=e[f++]<<n;n+=8}if(16>I)m>>>=u,n-=u,c.lens[c.have++]=I;else{if(16===I){for(z=
u+2;n<z;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}m>>>=u;n-=u;if(0===c.have){a.msg="invalid bit length repeat";c.mode=30;break}z=c.lens[c.have-1];u=3+(m&3);m>>>=2;n-=2}else if(17===I){for(z=u+3;n<z;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}m>>>=u;n-=u;z=0;u=3+(m&7);m>>>=3;n-=3}else{for(z=u+7;n<z;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}m>>>=u;n-=u;z=0;u=11+(m&127);m>>>=7;n-=7}if(c.have+u>c.nlen+c.ndist){a.msg="invalid bit length repeat";c.mode=30;break}for(;u--;)c.lens[c.have++]=z}}if(30===c.mode)break;
if(0===c.lens[256]){a.msg="invalid code -- missing end-of-block";c.mode=30;break}c.lenbits=9;u={bits:c.lenbits};N=F(1,c.lens,0,c.nlen,c.lencode,0,c.work,u);c.lenbits=u.bits;if(N){a.msg="invalid literal/lengths set";c.mode=30;break}c.distbits=6;c.distcode=c.distdyn;u={bits:c.distbits};N=F(2,c.lens,c.nlen,c.ndist,c.distcode,0,c.work,u);c.distbits=u.bits;if(N){a.msg="invalid distances set";c.mode=30;break}c.mode=20;if(6===b)break a;case 20:c.mode=21;case 21:if(6<=h&&258<=D){a.next_out=k;a.avail_out=
D;a.next_in=f;a.avail_in=h;c.hold=m;c.bits=n;G(a,J);k=a.next_out;g=a.output;D=a.avail_out;f=a.next_in;e=a.input;h=a.avail_in;m=c.hold;n=c.bits;12===c.mode&&(c.back=-1);break}for(c.back=0;;){I=c.lencode[m&(1<<c.lenbits)-1];u=I>>>24;z=I>>>16&255;I&=65535;if(u<=n)break;if(0===h)break a;h--;m+=e[f++]<<n;n+=8}if(z&&0===(z&240)){M=u;Q=z;for(P=I;;){I=c.lencode[P+((m&(1<<M+Q)-1)>>M)];u=I>>>24;z=I>>>16&255;I&=65535;if(M+u<=n)break;if(0===h)break a;h--;m+=e[f++]<<n;n+=8}m>>>=M;n-=M;c.back+=M}m>>>=u;n-=u;c.back+=
u;c.length=I;if(0===z){c.mode=26;break}if(z&32){c.back=-1;c.mode=12;break}if(z&64){a.msg="invalid literal/length code";c.mode=30;break}c.extra=z&15;c.mode=22;case 22:if(c.extra){for(z=c.extra;n<z;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.length+=m&(1<<c.extra)-1;m>>>=c.extra;n-=c.extra;c.back+=c.extra}c.was=c.length;c.mode=23;case 23:for(;;){I=c.distcode[m&(1<<c.distbits)-1];u=I>>>24;z=I>>>16&255;I&=65535;if(u<=n)break;if(0===h)break a;h--;m+=e[f++]<<n;n+=8}if(0===(z&240)){M=u;Q=z;for(P=I;;){I=c.distcode[P+
((m&(1<<M+Q)-1)>>M)];u=I>>>24;z=I>>>16&255;I&=65535;if(M+u<=n)break;if(0===h)break a;h--;m+=e[f++]<<n;n+=8}m>>>=M;n-=M;c.back+=M}m>>>=u;n-=u;c.back+=u;if(z&64){a.msg="invalid distance code";c.mode=30;break}c.offset=I;c.extra=z&15;c.mode=24;case 24:if(c.extra){for(z=c.extra;n<z;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}c.offset+=m&(1<<c.extra)-1;m>>>=c.extra;n-=c.extra;c.back+=c.extra}if(c.offset>c.dmax){a.msg="invalid distance too far back";c.mode=30;break}c.mode=25;case 25:if(0===D)break a;u=J-D;
if(c.offset>u){u=c.offset-u;if(u>c.whave&&c.sane){a.msg="invalid distance too far back";c.mode=30;break}u>c.wnext?(u-=c.wnext,z=c.wsize-u):z=c.wnext-u;u>c.length&&(u=c.length);M=c.window}else M=g,z=k-c.offset,u=c.length;u>D&&(u=D);D-=u;c.length-=u;do g[k++]=M[z++];while(--u);0===c.length&&(c.mode=21);break;case 26:if(0===D)break a;g[k++]=c.length;D--;c.mode=21;break;case 27:if(c.wrap){for(;32>n;){if(0===h)break a;h--;m|=e[f++]<<n;n+=8}J-=D;a.total_out+=J;c.total+=J;J&&(a.adler=c.check=c.flags?y(c.check,
g,J,k-J):p(c.check,g,J,k-J));J=D;if((c.flags?m:d(m))!==c.check){a.msg="incorrect data check";c.mode=30;break}n=m=0}c.mode=28;case 28:if(c.wrap&&c.flags){for(;32>n;){if(0===h)break a;h--;m+=e[f++]<<n;n+=8}if(m!==(c.total&4294967295)){a.msg="incorrect length check";c.mode=30;break}n=m=0}c.mode=29;case 29:N=1;break a;case 30:N=-3;break a;case 31:return-4;default:return-2}a.next_out=k;a.avail_out=D;a.next_in=f;a.avail_in=h;c.hold=m;c.bits=n;if((c.wsize||J!==a.avail_out&&30>c.mode&&(27>c.mode||4!==b))&&
q(a,a.output,a.next_out,J-a.avail_out))return c.mode=31,-4;l-=a.avail_in;J-=a.avail_out;a.total_in+=l;a.total_out+=J;c.total+=J;c.wrap&&J&&(a.adler=c.check=c.flags?y(c.check,g,J,a.next_out-J):p(c.check,g,J,a.next_out-J));a.data_type=c.bits+(c.last?64:0)+(12===c.mode?128:0)+(20===c.mode||15===c.mode?256:0);(0===l&&0===J||4===b)&&0===N&&(N=-5);return N};c.inflateEnd=function(a){if(!a||!a.state)return-2;var b=a.state;b.window&&(b.window=null);a.state=null;return 0};c.inflateGetHeader=function(a,b){var c;
if(!a||!a.state)return-2;c=a.state;if(0===(c.wrap&2))return-2;c.head=b;b.done=!1;return 0};c.inflateSetDictionary=function(a,b){var c=b.length,d,e;if(!a||!a.state)return-2;d=a.state;if(0!==d.wrap&&11!==d.mode)return-2;if(11===d.mode&&(e=p(1,b,c,0),e!==d.check))return-3;if(q(a,b,c,c))return d.mode=31,-4;d.havedict=1;return 0};c.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":62,"./adler32":64,"./crc32":66,"./inffast":69,"./inftrees":71}],71:[function(b,g,c){var d=b("../utils/common"),
e=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],a=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],h=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],k=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];g.exports=function(b,c,g,p,y,G,F,C){for(var w=C.bits,x=0,r=0,K=0,t=0,L=0,B=0,v=0,E=0,H=0,D=
0,m,n,l=null,J=0,u,z=new d.Buf16(16),B=new d.Buf16(16),M=null,I=0,Q,P,N,x=0;15>=x;x++)z[x]=0;for(r=0;r<p;r++)z[c[g+r]]++;L=w;for(t=15;1<=t&&0===z[t];t--);L>t&&(L=t);if(0===t)return y[G++]=20971520,y[G++]=20971520,C.bits=1,0;for(K=1;K<t&&0===z[K];K++);L<K&&(L=K);for(x=E=1;15>=x;x++)if(E<<=1,E-=z[x],0>E)return-1;if(0<E&&(0===b||1!==t))return-1;B[1]=0;for(x=1;15>x;x++)B[x+1]=B[x]+z[x];for(r=0;r<p;r++)0!==c[g+r]&&(F[B[c[g+r]]++]=r);0===b?(l=M=F,u=19):1===b?(l=e,J-=257,M=a,I-=257,u=256):(l=h,M=k,u=-1);
r=D=0;x=K;w=G;B=L;v=0;n=-1;H=1<<L;p=H-1;if(1===b&&852<H||2===b&&592<H)return 1;for(;;){Q=x-v;F[r]<u?(P=0,N=F[r]):F[r]>u?(P=M[I+F[r]],N=l[J+F[r]]):(P=96,N=0);E=1<<x-v;K=m=1<<B;do m-=E,y[w+(D>>v)+m]=Q<<24|P<<16|N|0;while(0!==m);for(E=1<<x-1;D&E;)E>>=1;0!==E?(D&=E-1,D+=E):D=0;r++;if(0===--z[x]){if(x===t)break;x=c[g+F[r]]}if(x>L&&(D&p)!==n){0===v&&(v=L);w+=K;B=x-v;for(E=1<<B;B+v<t;){E-=z[B+v];if(0>=E)break;B++;E<<=1}H+=1<<B;if(1===b&&852<H||2===b&&592<H)return 1;n=D&p;y[n]=L<<24|B<<16|w-G|0}}0!==D&&(y[w+
D]=x-v<<24|4194304);C.bits=L;return 0}},{"../utils/common":62}],72:[function(b,g,c){g.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],73:[function(b,g,c){function d(a){for(var b=a.length;0<=--b;)a[b]=0}function e(a,b,c,d,e){this.static_tree=a;this.extra_bits=b;this.extra_base=c;this.elems=d;this.max_length=e;this.has_stree=a&&a.length}function a(a,b){this.dyn_tree=
a;this.max_code=0;this.stat_desc=b}function h(a,b){a.pending_buf[a.pending++]=b&255;a.pending_buf[a.pending++]=b>>>8&255}function k(a,b,c){a.bi_valid>16-c?(a.bi_buf|=b<<a.bi_valid&65535,h(a,a.bi_buf),a.bi_buf=b>>16-a.bi_valid,a.bi_valid+=c-16):(a.bi_buf|=b<<a.bi_valid&65535,a.bi_valid+=c)}function f(a,b,c){k(a,c[2*b],c[2*b+1])}function q(a,b){var c=0;do c|=a&1,a>>>=1,c<<=1;while(0<--b);return c>>>1}function A(a,b,c){var d=Array(16),e=0,f;for(f=1;15>=f;f++)d[f]=e=e+c[f-1]<<1;for(c=0;c<=b;c++)e=a[2*
c+1],0!==e&&(a[2*c]=q(d[e]++,e))}function p(a){var b;for(b=0;286>b;b++)a.dyn_ltree[2*b]=0;for(b=0;30>b;b++)a.dyn_dtree[2*b]=0;for(b=0;19>b;b++)a.bl_tree[2*b]=0;a.dyn_ltree[512]=1;a.opt_len=a.static_len=0;a.last_lit=a.matches=0}function y(a){8<a.bi_valid?h(a,a.bi_buf):0<a.bi_valid&&(a.pending_buf[a.pending++]=a.bi_buf);a.bi_buf=0;a.bi_valid=0}function G(a,b,c,d){var e=2*b,f=2*c;return a[e]<a[f]||a[e]===a[f]&&d[b]<=d[c]}function F(a,b,c){for(var d=a.heap[c],e=c<<1;e<=a.heap_len;){e<a.heap_len&&G(b,
a.heap[e+1],a.heap[e],a.depth)&&e++;if(G(b,d,a.heap[e],a.depth))break;a.heap[c]=a.heap[e];c=e;e<<=1}a.heap[c]=d}function C(a,b,c){var d,e,g=0,h,m;if(0!==a.last_lit){do d=a.pending_buf[a.d_buf+2*g]<<8|a.pending_buf[a.d_buf+2*g+1],e=a.pending_buf[a.l_buf+g],g++,0===d?f(a,e,b):(h=l[e],f(a,h+256+1,b),m=B[h],0!==m&&(e-=J[h],k(a,e,m)),d--,h=256>d?n[d]:n[256+(d>>>7)],f(a,h,c),m=v[h],0!==m&&(d-=u[h],k(a,d,m)));while(g<a.last_lit)}f(a,256,b)}function w(a,b){var c=b.dyn_tree,d=b.stat_desc.static_tree,e=b.stat_desc.has_stree,
f=b.stat_desc.elems,g,h=-1,k;a.heap_len=0;a.heap_max=573;for(g=0;g<f;g++)0!==c[2*g]?(a.heap[++a.heap_len]=h=g,a.depth[g]=0):c[2*g+1]=0;for(;2>a.heap_len;)k=a.heap[++a.heap_len]=2>h?++h:0,c[2*k]=1,a.depth[k]=0,a.opt_len--,e&&(a.static_len-=d[2*k+1]);b.max_code=h;for(g=a.heap_len>>1;1<=g;g--)F(a,c,g);k=f;do g=a.heap[1],a.heap[1]=a.heap[a.heap_len--],F(a,c,1),d=a.heap[1],a.heap[--a.heap_max]=g,a.heap[--a.heap_max]=d,c[2*k]=c[2*g]+c[2*d],a.depth[k]=(a.depth[g]>=a.depth[d]?a.depth[g]:a.depth[d])+1,c[2*
g+1]=c[2*d+1]=k,a.heap[1]=k++,F(a,c,1);while(2<=a.heap_len);a.heap[--a.heap_max]=a.heap[1];g=b.dyn_tree;k=b.max_code;for(var l=b.stat_desc.static_tree,m=b.stat_desc.has_stree,n=b.stat_desc.extra_bits,q=b.stat_desc.extra_base,p=b.stat_desc.max_length,r,t,u=0,f=0;15>=f;f++)a.bl_count[f]=0;g[2*a.heap[a.heap_max]+1]=0;for(d=a.heap_max+1;573>d;d++)e=a.heap[d],f=g[2*g[2*e+1]+1]+1,f>p&&(f=p,u++),g[2*e+1]=f,e>k||(a.bl_count[f]++,r=0,e>=q&&(r=n[e-q]),t=g[2*e],a.opt_len+=t*(f+r),m&&(a.static_len+=t*(l[2*e+
1]+r)));if(0!==u){do{for(f=p-1;0===a.bl_count[f];)f--;a.bl_count[f]--;a.bl_count[f+1]+=2;a.bl_count[p]--;u-=2}while(0<u);for(f=p;0!==f;f--)for(e=a.bl_count[f];0!==e;)l=a.heap[--d],l>k||(g[2*l+1]!==f&&(a.opt_len+=(f-g[2*l+1])*g[2*l],g[2*l+1]=f),e--)}A(c,h,a.bl_count)}function x(a,b,c){var d,e=-1,f,g=b[1],h=0,k=7,l=4;0===g&&(k=138,l=3);b[2*(c+1)+1]=65535;for(d=0;d<=c;d++)f=g,g=b[2*(d+1)+1],++h<k&&f===g||(h<l?a.bl_tree[2*f]+=h:0!==f?(f!==e&&a.bl_tree[2*f]++,a.bl_tree[32]++):10>=h?a.bl_tree[34]++:a.bl_tree[36]++,
h=0,e=f,0===g?(k=138,l=3):f===g?(k=6,l=3):(k=7,l=4))}function r(a,b,c){var d,e=-1,g,h=b[1],l=0,m=7,n=4;0===h&&(m=138,n=3);for(d=0;d<=c;d++)if(g=h,h=b[2*(d+1)+1],!(++l<m&&g===h)){if(l<n){do f(a,g,a.bl_tree);while(0!==--l)}else 0!==g?(g!==e&&(f(a,g,a.bl_tree),l--),f(a,16,a.bl_tree),k(a,l-3,2)):10>=l?(f(a,17,a.bl_tree),k(a,l-3,3)):(f(a,18,a.bl_tree),k(a,l-11,7));l=0;e=g;0===h?(m=138,n=3):g===h?(m=6,n=3):(m=7,n=4)}}function K(a){var b=4093624447,c;for(c=0;31>=c;c++,b>>>=1)if(b&1&&0!==a.dyn_ltree[2*c])return 0;
if(0!==a.dyn_ltree[18]||0!==a.dyn_ltree[20]||0!==a.dyn_ltree[26])return 1;for(c=32;256>c;c++)if(0!==a.dyn_ltree[2*c])return 1;return 0}function t(a,b,c,d){k(a,0+(d?1:0),3);y(a);h(a,c);h(a,~c);L.arraySet(a.pending_buf,a.window,b,c,a.pending);a.pending+=c}var L=b("../utils/common"),B=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],v=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],E=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],H=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,
1,15],D=Array(576);d(D);var m=Array(60);d(m);var n=Array(512);d(n);var l=Array(256);d(l);var J=Array(29);d(J);var u=Array(30);d(u);var z,M,I,Q=!1;c._tr_init=function(b){if(!Q){var c,d,f,g=Array(16);for(f=d=0;28>f;f++)for(J[f]=d,c=0;c<1<<B[f];c++)l[d++]=f;l[d-1]=f;for(f=d=0;16>f;f++)for(u[f]=d,c=0;c<1<<v[f];c++)n[d++]=f;for(d>>=7;30>f;f++)for(u[f]=d<<7,c=0;c<1<<v[f]-7;c++)n[256+d++]=f;for(c=0;15>=c;c++)g[c]=0;for(c=0;143>=c;)D[2*c+1]=8,c++,g[8]++;for(;255>=c;)D[2*c+1]=9,c++,g[9]++;for(;279>=c;)D[2*
c+1]=7,c++,g[7]++;for(;287>=c;)D[2*c+1]=8,c++,g[8]++;A(D,287,g);for(c=0;30>c;c++)m[2*c+1]=5,m[2*c]=q(c,5);z=new e(D,B,257,286,15);M=new e(m,v,0,30,15);I=new e([],E,0,19,7);Q=!0}b.l_desc=new a(b.dyn_ltree,z);b.d_desc=new a(b.dyn_dtree,M);b.bl_desc=new a(b.bl_tree,I);b.bi_buf=0;b.bi_valid=0;p(b)};c._tr_stored_block=t;c._tr_flush_block=function(a,b,c,d){var e,f,g=0;if(0<a.level){2===a.strm.data_type&&(a.strm.data_type=K(a));w(a,a.l_desc);w(a,a.d_desc);x(a,a.dyn_ltree,a.l_desc.max_code);x(a,a.dyn_dtree,
a.d_desc.max_code);w(a,a.bl_desc);for(g=18;3<=g&&0===a.bl_tree[2*H[g]+1];g--);a.opt_len+=3*(g+1)+14;e=a.opt_len+3+7>>>3;f=a.static_len+3+7>>>3;f<=e&&(e=f)}else e=f=c+5;if(c+4<=e&&-1!==b)t(a,b,c,d);else if(4===a.strategy||f===e)k(a,2+(d?1:0),3),C(a,D,m);else{k(a,4+(d?1:0),3);b=a.l_desc.max_code+1;c=a.d_desc.max_code+1;g+=1;k(a,b-257,5);k(a,c-1,5);k(a,g-4,4);for(e=0;e<g;e++)k(a,a.bl_tree[2*H[e]+1],3);r(a,a.dyn_ltree,b-1);r(a,a.dyn_dtree,c-1);C(a,a.dyn_ltree,a.dyn_dtree)}p(a);d&&y(a)};c._tr_tally=function(a,
b,c){a.pending_buf[a.d_buf+2*a.last_lit]=b>>>8&255;a.pending_buf[a.d_buf+2*a.last_lit+1]=b&255;a.pending_buf[a.l_buf+a.last_lit]=c&255;a.last_lit++;0===b?a.dyn_ltree[2*c]++:(a.matches++,b--,a.dyn_ltree[2*(l[c]+256+1)]++,a.dyn_dtree[2*(256>b?n[b]:n[256+(b>>>7)])]++);return a.last_lit===a.lit_bufsize-1};c._tr_align=function(a){k(a,2,3);f(a,256,D);16===a.bi_valid?(h(a,a.bi_buf),a.bi_buf=0,a.bi_valid=0):8<=a.bi_valid&&(a.pending_buf[a.pending++]=a.bi_buf&255,a.bi_buf>>=8,a.bi_valid-=8)}},{"../utils/common":62}],
74:[function(b,g,c){g.exports=function(){this.input=null;this.total_in=this.avail_in=this.next_in=0;this.output=null;this.total_out=this.avail_out=this.next_out=0;this.msg="";this.state=null;this.data_type=2;this.adler=0}},{}]},{},[10])(10)});
